/**
 * Copyright oxmo_456 ( http://wonderfl.net/user/oxmo_456 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1lfQ
 */

package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.utils.setTimeout;

    public class Main extends Sprite {
        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;

            var console : BasicConsole = new BasicConsole();
            console.width = stage.stageWidth;
            console.height = stage.stageHeight;
            addChild(console);

            var container : Sprite = new Sprite();
        
            addChild(container);
            var shape : Shape = new Shape();
            container.addChild(shape);

            shape.graphics.beginFill(0xff0000,0.2);
            shape.graphics.drawRect(0, 0, 100, 500);
            shape.graphics.endFill();
            var r : Rectangle = new Rectangle(0, 0, 100, 100);
            shape.scrollRect = r;

            
            console.println("shape 1 init " + shape.width + " " + shape.height);
            console.println("container 1 init " + container.width + " " + container.height);

            setTimeout(function() : void {
                console.println("shape 1 after 100ms " + shape.width + " " + shape.height);
                console.println("container 1 after 100ms " + container.width + " " + container.height);
                
                console.println("scrollRect reset");
        
                shape.scrollRect = r;
        
                console.println("shape 1 after 100ms and scrollRect reset " + shape.width + " " + shape.height);
                console.println("container 1 after 100ms and scrollRect reset " + container.width + " " + container.height);

            }, 100);

            stage.addEventListener(MouseEvent.CLICK, function() : void {
                shape.scrollRect = r;

                console.println("shape 1 scrollRect reset on click " + shape.width + " " + shape.height);
                console.println("container 1 scrollRect reset on click " + container.width + " " + container.height);

            });
        }
    }
}
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

internal class BasicConsole extends Sprite {
    private static const DEFAULT_WIDTH : Number = 200;
    private static const DEFAULT_HEIGHT : Number = 200;
    private var textField : TextField;

    public function BasicConsole() {
        textField = new TextField();
        var textFormat : TextFormat = new TextFormat();
        textFormat.font = "Verdana";
        textFormat.size = 9;
        textFormat.color = 0xffffff;
        textField.defaultTextFormat = textFormat;
        textField.background = true;
        textField.backgroundColor = 0x000000;
        textField.multiline = true;
        textField.wordWrap = true;
        addChild(textField);
        textField.width = DEFAULT_WIDTH;
        textField.height = DEFAULT_HEIGHT;
    }

    override public function set width(value : Number) : void {
        textField.width = value;
    }

    override public function set height(value : Number) : void {
        textField.height = value;
    }

    public function dispose() : void {
        // TODO
    }

    public function println(text : String) : void {
        textField.appendText(text + "\n");
        textField.scrollV = textField.maxScrollV;
    }
}
