/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1kaV
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#FFFFFF")]

    public class Main extends Sprite
    {
        static private const VIDEO_WIDTH  :int    = 320;
        static private const VIDEO_HEIGHT :int    = 240;
        static private const DECLARATION  :Number = .025;
        
        private var wrap  :Sprite;
        private var video :Video;
        
        public function Main():void
        {
            // ステージの設定
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            // コンテナーの作成
            wrap = new Sprite();
            addChild(wrap);
            
            // ウェブカメラの作成
            var webCamera:Camera = Camera.getCamera();
            video = new Video(VIDEO_WIDTH, VIDEO_HEIGHT);
            video.x = - VIDEO_WIDTH  / 2;
            video.y = - VIDEO_HEIGHT / 2;
            video.attachCamera(webCamera);
            wrap.addChild(video);
            
            // 毎フレームのレンダリング
            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
                
        private function enterFrameHandler(event:Event):void
        {
            // マウス位置に応じて回転
            wrap.rotationX += (mouseY/stage.stageHeight * 720 - wrap.rotationX) * DECLARATION;
            wrap.rotationY += (mouseX/stage.stageWidth  * 720 - wrap.rotationY) * DECLARATION;
            
            // ステージサイズに応じて中央に移動
            // (ホントはresizeイベントで拾うのですが、ラクしました。。)
            wrap.x = stage.stageWidth  / 2;
            wrap.y = stage.stageHeight / 2;
        }        
    }
}