/**
 * Copyright talte ( http://wonderfl.net/user/talte )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1kSS
 */

/*
  マップ素材は以下からお借りして使用しています
   DotWorld http://whss.biz/~tsukasa/
*/
package
{
	import flash.display.Sprite
	import flash.display.Bitmap
	import flash.display.BitmapData
	import flash.events.Event
	import flash.events.MouseEvent
	import flash.display.Loader
	import flash.display.LoaderInfo
	import flash.system.LoaderContext
	import flash.net.URLLoader
	import flash.net.URLRequest
	import flash.geom.Point
	import flash.geom.Rectangle
    
	public class autotile extends Sprite
	{
		private var field:Bitmap // 表示されるマップ
		private var chip:Bitmap  // マップチップ画像
		
		private var mapdata:Array  // マップのデータ配列
		private var map_width:int  // マップの幅
		private var map_height:int // マップの高さ
		
		private var mousedown:Boolean = false // マウスが押されているか
		private var chip_select:int // 選択されているチップ
		
		function autotile()
		{
			this.addEventListener(Event.ADDED_TO_STAGE, this.onLoad) // 初期化
		}
		
		// 初期化
		private function onLoad(event:Event):void
		{
			// マップ画像読み込み
			var url:String = "http://assets.wonderfl.net/images/related_images/0/0f/0f7d/0f7df367b7a9f8d90d808d415c91affc1ec5ab6e"
			var loader:Loader = new Loader
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this.onComplete)
			loader.load(new URLRequest(url), new LoaderContext(true))
		}
		
		// マップ読み込み完了
		private function onComplete(event:Event):void
		{
			// マップチップ画像
			var loader:Loader = LoaderInfo(event.target).loader
			this.chip = Bitmap(loader.content)
			
			// 以下マップが読み込めたので初期化開始
			
			// マップ表示の初期化
			var bmpData:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight)
			this.field = new Bitmap(bmpData)
			this.addChild(this.field)
			
			// マップデータの初期化
			this.map_width = (stage.stageWidth + 31) / 32
			this.map_height = (stage.stageHeight + 31) / 32
			var len:int = this.map_width * this.map_height // 幅×高さ分必要
			this.mapdata = new Array
			for (var i:int = 0; i < len; i++)
			{
				this.mapdata[i] = 0; // 最初はすべて0のチップ
			}
			
			// マップ表示初期化描画
			var rect:Rectangle = new Rectangle(0, 0, 32, 32)
			var point:Point = new Point(0, 0)
			for (i = 0; i < this.map_width; i++)
			{
				for (var j:int = 0; j < this.map_height; j++)
				{
					// 全座標描画
					point.x = i * 32
					point.y = j * 32
					this.field.bitmapData.copyPixels(this.chip.bitmapData, rect, point)
				}
			}
			
			// マウスのイベント登録
			stage.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown)
			stage.addEventListener(MouseEvent.MOUSE_UP, this.onMouseUp)
			stage.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove)
		}
		
		// クリックした
		private function onMouseDown(event:MouseEvent):void
		{
			var x:int = event.stageX / 32
			var y:int = event.stageY / 32 // マウスのチップ位置
			
			this.mousedown = true // マウスクリック状態
			this.chip_select = 1 - this.map(x, y) // 今回は２種類のチップを反転
			
			this.setmap(x, y) // マップ更新
		}
		
		// クリックを離した
		private function onMouseUp(event:MouseEvent):void
		{
			this.mousedown = false // マウスクリック解除
		}
		
		// マウスが動いた
		private function onMouseMove(event:MouseEvent):void
		{
			if(this.mousedown) // マウスクリック中
			{
				var x:int = event.stageX / 32
				var y:int = event.stageY / 32 // マウス位置
				
				this.setmap(x, y) // マップ更新
			}
		}
		
		// チップ番号取得用
		private function map(x:int, y:int):int
		{
			// マップ範囲外は特別な番号を返す
			if (x < 0 || x >= this.map_width || y < 0 || y >= this.map_height)
			{
				return -1
			}
			return this.mapdata[x + y * this.map_width] // データの格納位置
		}
		
		// マップ更新
		private function setmap(x:int, y:int):void
		{
			var pos:int = x + y * this.map_width // データの格納位置
			
			// 変更されていたら描画も
			if (this.mapdata[pos] != this.chip_select)
			{
				this.mapdata[pos] = this.chip_select
				this.drawmap(x, y)
			}
		}
		
		// マップ描画
		private function drawmap(x:int, y:int):void
		{
			var rect:Rectangle = new Rectangle(0, 0, 16, 16) // 16×16ずつ描画
			var point:Point = new Point(0, 0)
			
			// 更新範囲はチップの半分のサイズで周りを含めた4×4
			for (var i:int = 0; i < 4; i++)
			{
				for (var j:int = 0; j < 4; j++)
				{
					// 自身の座標
					var ox:int = x + ((i + 1) / 2 - 1)
					var oy:int = y + ((j + 1) / 2 - 1) // (-1)/2対策
					// 自身のチップを決めるための周辺の座標用
					var tx:int = ox + (i % 2 == 0 ? 1 : -1) // 例えば描画対象チップが右下半分ならその右のチップを確認
					var ty:int = oy + (j % 2 == 0 ? 1 : -1) // またその下や右下のチップも確認
					
					// 描画するチップを決める
					var sel:int // 選択チップ
					var n:int = this.map(ox, oy) // 自身のチップ番号
					// 今回は簡単にするためただ分ける
					if (n == 1) // 今回は池
					{
						var v:int = this.map(tx, oy) // 横
						var h:int = this.map(ox, ty) // 縦
						var vh:int = this.map(tx, ty) // 斜め
						
						// 例えば左上なら、左、左上、上がすべて池
						if (v == n && h == n && vh == n)
						{
							sel = 5
						}
						// 左と上が池
						else if (v == n && h == n)
						{
							sel = 2
						}
						// 左だけ
						else if (v == n)
						{
							sel = 3
						}
						// 上だけ
						else if (h == n)
						{
							sel = 4
						}
						// 左上のみ、もしくはなし
						else
						{
							sel = 1
						}
					}
					else
					{
						sel = 0 // 今回は草のみ
					}
					
					// 描画の位置
					point.x = 16 * (x * 2 - 1 + i)
					point.y = 16 * (y * 2 - 1 + j)
					// チップの切り取る場所
					rect.x = 16 * (sel * 2 + (i % 2 == 0 ? 1 : 0))
					rect.y = 16 * (j % 2 == 0 ? 1 : 0) // これも左上とか右下とかで調整
					
					// 描画
					this.field.bitmapData.copyPixels(this.chip.bitmapData, rect, point)
				}
			}
		}
	}
}