/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1k7t
 */

// forked from John_Blackburne's flash on 2011-12-16
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        
        public const kDirNum:int       = 64;
        public const kNumTrials:int    = 5000000;
        
        public var aSin:Vector.<Number>;
        public var aCos:Vector.<Number>;
        
        public var tf:TextField;

        public function FlashTest() {
            var iTime:int;
            
            InitText();
            InitTrigTable();
            
            iTime = getTimer();
            TestTables();
            tf.appendText("Tables:" + String(getTimer() - iTime));

            iTime = getTimer();
            TestFunctions();
            tf.appendText("\nFunctions:" + String(getTimer() - iTime));

            tf.appendText("\nDone");
        }
        
        public function InitText():void {
            tf = new TextField();
            addChild(tf);
        }

        public function InitTrigTable():void {
            var iDir:int, fAngle:Number;
            
            aSin = new Vector.<Number>(kDirNum);    
            aCos = new Vector.<Number>(kDirNum);    
            for (iDir = 0; iDir < kDirNum; iDir++) {
                fAngle = iDir * 2 * Math.PI / kDirNum;
                aSin[iDir] = Math.sin(fAngle);
                aCos[iDir] = Math.cos(fAngle);
            }
        }

        public function TestTables():void {
            var iTrial:int, iDir:int, fSin:Number, fCos:Number, fSum:Number;
            fSum = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                iDir = iTrial % kDirNum;
                fSin = aSin[iDir];
                fCos = aCos[iDir];
                fSum += fSin + fCos;
            }
        }

        public function TestFunctions():void {
            var iTrial:int, iDir:int, fAngle:Number, fSin:Number,
                fCos:Number, fSum:Number;
            fSum = 0;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                iDir = iTrial % kDirNum;
                fAngle = iDir * 2 * Math.PI / kDirNum;
                fSin = Math.sin(fAngle);
                fCos = Math.cos(fAngle);
                fSum += fSin + fCos;
            }
        }

    }
}