/**
 * Copyright TheCoolMuseum ( http://wonderfl.net/user/TheCoolMuseum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1k0j
 */

// forked from TheCoolMuseum's 画像のWAVファイル化 誤差拡散2値化付
// forked from TheCoolMuseum's forked from: 画像のWAVファイル化
// forked from TheCoolMuseum's 画像のWAVファイル化
// forked from TheCoolMuseum's ローカルファイルの読み込み・保存
// 画像を誤差拡散法で２値化します

package {
	import flash.utils.IDataInput;
	import flash.display.InterpolationMethod;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.ByteArray;
    import flash.utils.Endian;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.net.FileReference;
    import flash.net.FileFilter;
    
    public class FlashTest extends Sprite {
        private var fileLoader:FileReference;
        private var fileSaver:FileReference;
        private var imageLoader:Loader;
        private var image:Bitmap = new Bitmap();
        
        private var uIx:Array = [0,2,1,3,0,2,1,3,0,2,1,3,0,2,1,3];
        private var vIx:Array = [0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3];
        
        public function makeBtn(name:String):TextField{
           var btn:TextField = new TextField();
            btn.text = name;
            btn.autoSize = TextFieldAutoSize.LEFT;
            btn.background = true;
            btn.border = true;
            btn.selectable = false;
            return btn;
        } 
        public function FlashTest() {
        	    image.y=20;
        	    addChild(image);
            var loadBtn:TextField = makeBtn("LOAD");
            addChild(loadBtn);
            loadBtn.addEventListener(MouseEvent.CLICK, onClickLoadBtn);
            
        }
        private function onClickLoadBtn(e:Event):void{
            load();
        }
        private function load():void{
            var fileFilter:FileFilter = new FileFilter("Images (.png .jpg .gif)", "*.png;*.jpg;*.gif");

           	fileLoader = new FileReference();
        	fileLoader.addEventListener(Event.SELECT, onSelectLoadFile);
        	fileLoader.addEventListener(Event.COMPLETE, onCompleteLoadFile);
        	
        	fileLoader.browse([fileFilter]);
        }
        private function onSelectLoadFile(e:Event):void{
            fileLoader.load();
        }
        private function onCompleteLoadFile(e:Event):void{
            imageLoader = new Loader();
            imageLoader.loadBytes(fileLoader.data);
            imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteLoadImage);
        }
        private function onCompleteLoadImage(e:Event):void{
            var width:int = imageLoader.width;
            var height:int = imageLoader.height;
            var bitmapData:BitmapData = new BitmapData(width, height);
            bitmapData.draw(imageLoader);
            //addChild(new Bitmap(bitmapData));
            image.bitmapData = errorDiffusion(bitmapData);
            
        }
        
        private function errorDiffusion(img:BitmapData):BitmapData{
        		var width:int = img.width;
        		var height:int = img.height;
        		var array:ByteArray = img.getPixels(img.rect);
        		var l:int=array.length;
        		for(var y:int=0; y<height; y++){
        			var pos:int = y*width*4;
        			for(var x:int=0; x<width; x++){
        				var c:int = array[pos+1]+array[pos+2]+array[pos+3];
        				c /= 3;
                     var dst:Number = c>127 ? 255 : 0;
                     var err:Number = c-dst;
                     var c1:int = err*5/16;
                     var c2:int = err*3/16;

                     array[pos] = 0xff;
                     array[pos+1] = dst;
                     array[pos+2] = dst;
                     array[pos+3] = dst;
                     if(y<height-1){
                           array[pos+width*4+1] = clip8bit((array[pos+width*4+1]+array[pos+width*4+2]+array[pos+width*4+3])/3 + c1);
                           array[pos+width*4+2] = array[pos+width*4+1];
                           array[pos+width*4+3] = array[pos+width*4+1];
                        if(x<width-1){
                            array[pos+5] = clip8bit((array[pos+5] +array[pos+6] +array[pos+7])/3 + c1);
                            array[pos+6] = array[pos+5];
                            array[pos+7] = array[pos+5];
                            array[pos+width*4+5] = clip8bit((array[pos+width*4+5] + array[pos+width*4+6] + array[pos+width*4+7])/3 + c2);
                            array[pos+width*4+6] = array[pos+width*4+5];
                            array[pos+width*4+7] = array[pos+width*4+5];
                        }
                        if(x>0){
                            array[pos+width*4-3] = clip8bit((array[pos+width*4-3] + array[pos+width*4-2] + array[pos+width*4-1])/3 + c2);
                            array[pos+width*4-2] = array[pos+width*4-3];
                            array[pos+width*4-1] = array[pos+width*4-3];
                        }
                     }else{
                        if(x<width-1){
                            array[pos+5] = clip8bit((array[pos+5] + array[pos+6] + array[pos+7])/3 + c1);
                            array[pos+6] = array[pos+5];
                            array[pos+7] = array[pos+5];
                        }
                     }
                     pos+=4;
        			}
        		}
        		array.position=0;
            img.setPixels(img.rect, array);
        
        		return img;
        }
        private function clip8bit(n:int):int{
        		return Math.min(255,Math.max(0,n));
        }
    }
}