/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1jkP
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	[SWF(frameRate = 30)]
    public class FlashTest extends Sprite
	{
        public function FlashTest()
		{
			field = new Array();
			fieldWidth = 20;
			fieldHeight = 16;
			
			for (var i:int = 0; i < fieldHeight * fieldWidth; i++)
			{
				var sp:Sprite = newCell();
				addChild(sp);
				sp.x = 20 + 20 * (i % fieldWidth);
				sp.y = 20 + 20 * (int)(i / fieldWidth);
				field[i] = sp;
			}
			
			effectCanvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
			addChild(new Bitmap(effectCanvas));
			ctEffect = new ColorTransform(1, 1, 1, .95);
			addEventListener(Event.ENTER_FRAME, loop);
        }
		
		private var field:Array;
		private var fieldWidth:int;
		private var fieldHeight:int;
		
		private var ctEffect:ColorTransform;
		private var effectCanvas:BitmapData;
		private function loop(e:Event):void 
		{
			if (particle != null)
			{
				effectCanvas.colorTransform(effectCanvas.rect, ctEffect);
				for each(var part:Object in particle)
				{
					if (part.life-- < 0)
					{
						particle.splice(particle.indexOf(part), 1);
					}
					else
					{
						var movevec:Point;
						with (part)
						{
							av += Math.random();
							if (av < 0) av *= -1;
							v = (v + av) / 2;
							movevec = new Point(x - this.mouseX, y - this.mouseY);
							movevec.normalize(v);
							x += movevec.x;
							y += movevec.y;
							color -= (int)(0xFF / PARTLIFE) << 24;
							effectCanvas.setPixel32(x, y, color);
						}
					}
				}
			}
			if (openQueue != null)
			{
				var openNum:int = openQueue.shift();
				if (openNum)
				{
					field[openNum].dispatchEvent(new MouseEvent(MouseEvent.MOUSE_DOWN))
				}
			}
		}
		
		private const PARTLIFE:int = 20;
		private const YSIZE:int = 512;
		private var particle:Array;
		private function disEffect(color:uint, pos:Number):void
		{
			var x:Number = pos % YSIZE;
			var y:Number = Math.floor(pos / YSIZE);
			if (particle == null) particle = new Array();
			for (var i:int = 0; i < 19; i++)
			{
				for (var k:int = 0; k < 19; k++)
				{
					var part:Object =
					{
						color:color,
						x:x + k,
						y:y + i,
						v:0,
						av:0,
						life:PARTLIFE
					};
					particle.push(part);
				}
			}
		}
		
		private function newCell():Sprite
		{
			var sp:Sprite = new Sprite();
			sp.graphics.beginFill(0xCCCCCC);
			sp.graphics.drawRect(0, 0, 19, 19);
			
			var color:uint = (int)(Math.random() * 0xFFFFFF) | 0xFF808080;
			var onOver:Function = function(e:MouseEvent):void
			{
				sp.graphics.clear();
				color = (int)(Math.random() * 0xFFFFFF) | 0xFF808080;
				sp.graphics.beginFill(color);
				sp.graphics.drawRect(0, 0, 19, 19);
			}
			sp.addEventListener(MouseEvent.ROLL_OVER, onOver);
			
			var onOut:Function = function(e:MouseEvent):void
			{
				sp.graphics.clear();
				sp.graphics.beginFill(0xCCCCCC);
				sp.graphics.drawRect(0, 0, 19, 19);
			}
			sp.addEventListener(MouseEvent.ROLL_OUT, onOut);
			
			var onMDown:Function = function(e:MouseEvent):void
			{
				sp.removeEventListener(MouseEvent.MOUSE_DOWN, onMDown);
				sp.removeEventListener(MouseEvent.ROLL_OVER, onOver);
				sp.removeEventListener(MouseEvent.ROLL_OUT, onOut);
				sp.graphics.clear();
				sp.graphics.beginFill(0xFFFFFF);
				sp.graphics.drawRect(0, 0, 19, 19);
				disEffect(color, sp.x + sp.y * YSIZE);
				openCell(sp);
			}
			sp.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
			return sp;
		}
		
		private var mineField:Array;
		private var mineNum:int = 50;
		
		private function openCell(cell:Sprite):void
		{
			var cellNum:int = field.indexOf(cell);
			
			if (mineField == null)
			{
				mineField = new Array();
				var temp:Array = new Array();
				for (var i:int = 0; i < fieldWidth * fieldHeight-1; i++)
				{
					temp.push(i < mineNum ? true : false);
				}
				for (var k:int = 0; k < fieldWidth * fieldHeight; k++)
				{
					if (k == cellNum)
					{
						mineField.push(false);
						continue;
					}
					var index:int = Math.floor(Math.random() * temp.length);
					mineField.push(temp[index]);
					temp.splice(index, 1);
				}
			}
			
			var tf:TextField = new TextField();
			var format:TextFormat = new TextFormat();
			format.align = "center";
			tf.defaultTextFormat = format;
			tf.width = 19;
			tf.height = 19;
			tf.selectable = false;
			if (mineField[cellNum])
			{
				tf.text = "死";
			}
			else
			{
				var danger:int = getDanger(cellNum);
				tf.text = danger + "";
				if (danger == 0)
				{
					openAround(cellNum);
				}
			}
			cell.addChild(tf);
		}
		
		private function openAround(num:int):void
		{
			var x:int = num % fieldWidth;
			var y:int = Math.floor(num / fieldWidth);
			if (y > 0)
				pushOpenQueue(num - fieldWidth);
			if (x > 0)
				pushOpenQueue(num - 1);
			if (x < fieldWidth - 1)
				pushOpenQueue(num + 1);
			if (y < fieldHeight - 1)
				pushOpenQueue(num + fieldWidth);
		}
		
		private var openQueue:Array;
		private function pushOpenQueue(num:int):void
		{
			if (openQueue == null) openQueue = new Array();
			openQueue.push(num);
		}
		
		private function getDanger(num:int):int
		{
			var count:int = 0;
			var x:int = num % fieldWidth;
			var y:int = Math.floor(num / fieldWidth);
			
			if (y > 0)
			{
				if (x > 0) if (mineField[num - 1 - fieldWidth]) count++;
				if (mineField[num - fieldWidth]) count++;
				if (x < fieldWidth - 1) if (mineField[num + 1 - fieldWidth]) count++;
			}
			if (x > 0) if (mineField[num - 1]) count++;
			if (x < fieldWidth - 1) if (mineField[num + 1]) count++;
			if (y < fieldHeight - 1)
			{
				if (x > 0) if (mineField[num - 1 + fieldWidth]) count++;
				if (mineField[num + fieldWidth]) count++;
				if (x < fieldWidth - 1) if (mineField[num + 1 + fieldWidth]) count++;
			}
			return count;
		}
    }
}