/**
 * Copyright yurij.shaulov ( http://wonderfl.net/user/yurij.shaulov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1ijP
 */

package {

  import flash.display.*;

  import flash.geom.*;

  import flash.events.Event;

  import flash.net.URLRequest;

  import flash.system.ApplicationDomain;

  import flash.system.LoaderContext;

  public class ch36ex5 extends Sprite {

    public function ch36ex5() {

      var loader:Loader = new Loader();

      loader.load(

        new URLRequest("http://actionscriptbible.com/files/bitmaptiles.swf"),

        new LoaderContext(true));

      loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad);

    }

    protected function onLoad(event:Event):void {

      //extract A and B bitmaps from library SWF

      var L:ApplicationDomain = LoaderInfo(event.target).applicationDomain;

      var tileA:BitmapData = new (Class(L.getDefinition("assets.TileA")))(0,0);

      var tileB:BitmapData = new (Class(L.getDefinition("assets.TileB")))(0,0);



      var steps:int = 60;

      var size:Rectangle = tileA.rect;

      var wrapAt:Number = stage.stageWidth;

      var destination:Point = new Point(), origin:Point = new Point();

      var bmp:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);

      var tempBmp:BitmapData = new BitmapData(size.width, size.height);

      for (var i:int = 0; i < steps; i++) {

        //clear temp bitmap

        tempBmp.fillRect(size, 0);

        //temp bitmap = A

        tempBmp.copyPixels(tileA, tileA.rect, origin);

        var blend:int = i / steps * 256;

        //blend temp (contains A) and B into temp

        tempBmp.merge(tileB, tileB.rect, origin, blend, blend, blend, blend);

        //copy temp (A-B blend) into next position in grid

        bmp.copyPixels(tempBmp, tempBmp.rect, destination);

        

        destination.x += size.width;

        if (destination.x + size.width > wrapAt) {

          destination.y += size.height;

          destination.x = 0;

        }

      }

      var bitmap:Bitmap = new Bitmap(bmp);

      addChild(bitmap);

    }

  }

}