/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1hsa
 */

// forked from kotobuki's Arduino/Analog/Fading: physical x wonderfl way
// forked from kotobuki's Hello World! with Arduino: physical x wonderfl way
// An "Analog/Fading" example in physical x wonderfl way
// 
// Output:
// * A LED connected the D11 pin of a FIO
// 
// Reference:
// http://funnel.cc/Main/GettingStarted
// http://arduino.cc/en/Tutorial/Fading

package {
    import flash.display.Sprite;
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;
    
    public class FlashTest extends Sprite {
        private var fio:Fio;
        
        public function FlashTest() {
            var config:Configuration = Arduino.FIRMATA;            
            config.setDigitalPinMode(11, PWM);

            // set all analog pins output to stop unwanted
            // analog pin reporting
            // ピンのモードをOUTに設定するとFIOからPCへの通信量を
            // 最小限に抑えられる
            config.setDigitalPinMode(14, OUT);
            config.setDigitalPinMode(15, OUT);
            config.setDigitalPinMode(16, OUT);
            config.setDigitalPinMode(17, OUT);
            config.setDigitalPinMode(18, OUT);
            config.setDigitalPinMode(19, OUT);
            config.setDigitalPinMode(20, OUT);
            config.setDigitalPinMode(21, OUT);

            fio = new Fio([1], config);
            Osc.serviceInterval = 50;

            var led:LED = new LED(fio.ioModule(1).digitalPin(11));
 
            // The intercal (in ms), times (0 means infinite)
            // and the waveform.
            // Try Osc.SAW, Osc.TRIANGLE or Osc.SQUARE
            led.blink(1000, 0, Osc.SIN);
        }
    }
}