/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1hrv
 */

// forked from aaharu's 夢のキャスト Ver.1.1
// ちいせえｗｗｗ
// おまけにコード汚い
// 今後改良予定
/*
マイナーアップデート
大きくした＆文字入力に対応
1.5.1 -> 日本語文字入力に対応
*/
package {
	import com.bit101.components.InputText;
	import com.bit101.components.Label;
	import com.bit101.components.Panel;
	import com.bit101.components.PushButton;
	import com.bit101.components.RadioButton;
	import com.bit101.components.Style;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Cubic;
	import org.libspark.betweenas3.easing.Quad;
	import org.libspark.betweenas3.tweens.ITween;
	
	public class dc_startup extends Sprite {
		private const R:uint = 50;
		private const W:int = stage.stageWidth / 2;
		private const H:int = stage.stageHeight / 2;
		private var array:Array = [];
		private var ball:Ball;
		private var sp:Sprite;
		private var panel:Panel;
		private var textInput:InputText;
		private var jp:Boolean = true;
		
		public function dc_startup() {
			stage.scaleMode = StageScaleMode.SHOW_ALL;
			stage.align = StageAlign.TOP_LEFT;
			stage.frameRate = 60;
			
			Style.embedFonts = false;
			
			panel = new Panel(this, W - 100, H - 100);
			panel.setSize(200, 200);
			
			var label:Label = new Label(panel, 20, 20);
			label.text = "input text";
			
			textInput = new InputText(panel, 20, 40);
			textInput.width = 160;
			textInput.text = "Creamcast";
			
			var radio1:RadioButton = new RadioButton(panel, 60, 70, "J", true, onRadioClick);
			var radio2:RadioButton = new RadioButton(panel, 120, 70, "E", false, onRadioClick);
			
			var button:PushButton = new PushButton(panel, 50, 100, "start!", startup);
		}
		
		private function onRadioClick(e:MouseEvent):void {
			if(e.currentTarget.label == "j") {
				jp = true;
			} else {
				jp = false;
			}
		}
		
		private function startup(e:MouseEvent):void {
			removeChild(panel);
			var format:TextFormat = new TextFormat(null, 50);
			var temp:TextField = new TextField();
			temp.text = textInput.text;
			temp.setTextFormat(format);
			
			for(var i:uint = 0; i < textInput.text.length; i++) {
				var tf:TextField = new TextField();
				tf.text = textInput.text.charAt(i);
				tf.selectable = false;
				tf.setTextFormat(format);
				
				if(i) tf.x = array[i-1].x + array[i-1].textWidth;
				else tf.x = W - temp.textWidth / 2;
				tf.y = H + 25;
				array.push(tf);
			}
			
			ball = new Ball(jp);
			ball.x = array[0].x - 30;
			ball.y = H - 60;
			addChild(ball);
			
			var tween:ITween = BetweenAS3.bezierTo(ball, {x: array[0].x + array[0].textWidth, y: array[0].y + 35}, {x: array[0].x + 30, y: array[0].y - 20}, 2, Cubic.easeIn);
			tween.onComplete = bounce;
			tween.onCompleteParams = [1];
			tween.play();
		}
		
		private function bounce(n:uint):void {
			character(n-1);
			
			var tween:ITween = BetweenAS3.bezierTo(ball, {x: array[n].x + array[n].textWidth, y: ball.y}, {x: array[n].x + array[n].textWidth / 4, y: array[n].y - 10}, 0.35);
			if(n < textInput.text.length - 1) tween.onComplete = function():void { bounce(n+1) };
			else tween.onComplete = ぴょーん;
			tween.play();
		}
		
		private function character(index:uint):void {
			addChild(array[index]);
			BetweenAS3.tween(array[index], {y: array[index].y, alpha: 1}, {y: array[index].y + 20, alpha: 0}).play();
		}
		
		private function ぴょーん():void {
			character(textInput.text.length - 1);
			
			var tween:ITween = BetweenAS3.bezierTo(ball, {x: W, y: array[0].y - 35}, {x: (W + ball.x) / 2, y: array[0].y - 180}, 1.2, Quad.easeOut);
			tween.play();
			tween.onComplete = ぐるぐる;
		}
		
		private function ぐるぐる():void {
			sp = new Sprite();
			addChild(sp);
			sp.graphics.lineStyle(6, ball.color);
			sp.graphics.moveTo(ball.x, ball.y);
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			var tweenArray:Array = [];
			for(var i:uint = 0; i < 900; i++) {
				var toX:Number = ball.x - R * i / 720 * Math.cos(i * Math.PI / 180);
				var toY:Number = ball.y - R * i / 720 * Math.sin(i * Math.PI / 180);
				tweenArray.push(BetweenAS3.to(ball, {x: toX, y: toY}, 0.002));
			}
			var tween:ITween = BetweenAS3.serialTweens(tweenArray);
			tween.onComplete = function():void {
				removeEventListener(Event.ENTER_FRAME, onEnterFrame);
				sp.graphics.lineTo(ball.x, ball.y);
			};
			tween.play();
		}
		
		private function onEnterFrame(e:Event):void {
			sp.graphics.lineTo(ball.x, ball.y);
		}
	}
}

import flash.display.Sprite;

class Ball extends Sprite {
	private var _color:Number;
	
	public function get color():uint {
		return _color;
	}
	
	public function Ball(j:Boolean) {
		if(j) {
			graphics.beginFill(0xFF0000);
			_color = 0xFF0000;
		}
		else {
			graphics.beginFill(0x0000FF);
			_color = 0x0000FF;
		}
		graphics.drawCircle(0, 0, 4);
		graphics.endFill();
	}
}