/**
 * Copyright milchreis ( http://wonderfl.net/user/milchreis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1gpb
 */

// forked from mutantleg's flash on 2014-9-2
package 
{
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class Main extends Sprite 
    {
        private var t:Number = 0;
        private var _circle:Circle;
        private var _start:DraggableWrapper, _finish:DraggableWrapper;
        
        public function Main() 
        {
            _start = new DraggableWrapper(new Circle());
            _start.x = _start.y = 40;
            addChild(_start);
            
            _finish = new DraggableWrapper(new Circle());
            _finish.x = _finish.y = 200;
            addChild(_finish);
            
            addChild(new Line(_start, _finish));
            
            _circle = new Circle();
            addChild(_circle);
            
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        private function onEnter(e:Event):void
        {
            t += 0.01;
            
            if (t > 1)
                t = 0;
        
           _circle.x = _start.x * (1-t) + _finish.x * t;  
           _circle.y = _start.y * (1-t) + _finish.y * t;  
        }
    }
}

import flash.display.Sprite;
import flash.events.IEventDispatcher;

internal interface IPointModel extends IEventDispatcher
{
    function get x():Number;
    function get y():Number;
}
    
import flash.display.Shape;
    
internal class ColorfulShape extends Shape 
{
    private var _color:uint = 0;
    
    public function ColorfulShape(color:uint = 0) 
    {
        _color = color;
    }
    
    protected function draw():void
    {
        graphics.clear();
        graphics.lineStyle(2, _color);
    }
}    
    
internal class Circle extends ColorfulShape
{
    private var _radius:Number = 0;
    
    public function Circle(radius:Number = 8, color:uint = 0)
    {
        super(color);
        
        _radius = radius;
        
        draw();
    }
    
    public function get radius():Number
    {
        return _radius;
    }
    
    public function set radius(value:Number):void
    {
        if (_radius == value)
            return;
        
        _radius = value;
        
        draw();
    }
    
    override protected function draw():void
    {
        super.draw();
        graphics.beginFill(0xffffff);
        graphics.drawCircle(0, 0, _radius);
        graphics.endFill();
    }
}                        
    
import flash.events.Event;

internal class Line extends ColorfulShape 
{
    private var _a:IPointModel, _b:IPointModel;
    
    public function Line(a:IPointModel, b:IPointModel, color:uint=0) 
    {
        super(color);
        
        _a = a;
        _b = b;
        
        draw();
        
        _a.addEventListener(Event.CHANGE, onChange);
        _b.addEventListener(Event.CHANGE, onChange);
    }
    
    private function onChange(e:Event):void 
    {
        draw();
    }
    
    override protected function draw():void
    {
        super.draw();
        
        graphics.moveTo(_a.x, _a.y);
        graphics.lineTo(_b.x, _b.y);
    }
}

import flash.display.DisplayObject;
import flash.events.MouseEvent;

internal class DraggableWrapper extends Sprite implements IPointModel
{
    public function DraggableWrapper(asset:DisplayObject) 
    {
        addChild(asset);
        
        addEventListener(Event.ADDED_TO_STAGE, onStage);
        
        addEventListener(MouseEvent.MOUSE_DOWN, onDown);
    }
    
    private function onStage(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, onStage);
        
        stage.addEventListener(MouseEvent.MOUSE_UP, onUp, false, 0, true);
    }
    
    private function onDown(e:MouseEvent):void 
    {
        startDrag();
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
    }

    private function onUp(e:MouseEvent):void 
    {
        stopDrag();
        
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
    }
    
    private function onMove(e:MouseEvent):void 
    {
        dispatchEvent(new Event(Event.CHANGE));
    }
}