/**
 * Copyright jack.q.word ( http://wonderfl.net/user/jack.q.word )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1gne
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.geom.Transform;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.AntiAliasType;
    import flash.text.TextFormat;
    import flash.events.Event;
    import flash.text.TextFormatAlign;
    import flash.filters.GlowFilter;

    [SWF(frameRate = "16", width="1920", height="1080",backgroundColor="0")]
    public class MatrixCodeRain extends Sprite {

        public static const maxActiveChars:int = 300;
        public static const charPathWidth:int = 150;
        
        private var activeChars:Vector.<MatrixCodeChar> = new Vector.<MatrixCodeChar>();
        private var hiddenChars:Vector.<MatrixCodeChar> = new Vector.<MatrixCodeChar>();
        private var wash:ColorTransform = new ColorTransform(0.95, 0.992, 1, 0.992, 0, 0, 0, -0.2);
        private var glow:GlowFilter = new GlowFilter(0x00c0ff, 1, 8, 8, 2, 1, false, false);
        private var blur:BlurFilter = new BlurFilter(2, 2, 1);
        private var stampCanvas:BitmapData;
        private var canvasRect:Rectangle;
        private var charContainer:Sprite = new Sprite();
        private var bgCanvas:BitmapData;
        private var bgColor:Bitmap;
        private var fadingStamps:Bitmap;

        public function MatrixCodeRain() 
        {
            try {
                if (stage) init();
                else addEventListener(Event.ADDED_TO_STAGE, init);
            } catch(e:*) {
                trace("MatrixCodeRain");
                trace(e);
            }
        }

        private function init(e:Event = null):void {
            try {
                activeStage = stage;
                removeEventListener(Event.ADDED_TO_STAGE, init);

                addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xff000000)));
                canvasRect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);

                stampCanvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
                fadingStamps = new Bitmap(stampCanvas);
                
                charContainer.filters = [blur,glow];
                addChild(charContainer);
                
                fadingStamps.filters = [blur];
                addChild(fadingStamps);

                addEventListener(Event.ENTER_FRAME, refresh);
            } catch(e:*) {
                trace("MatrixCodeRain.init");
                trace(e);
            }
        }
        
        public function stampChar(char:MatrixCodeChar):void {
            try {
                stampCanvas.draw(char,char.transform.matrix);
            } catch(e:*) {
                trace("MatrixCodeRain.refreshLabel");
                trace(e);
            }
        }

        
        private function refresh(e:Event):void {
            try {
                stampCanvas.colorTransform(canvasRect, wash);
                var char:MatrixCodeChar;
                for (var i:int = 0; i < activeChars.length; i++) {
                    try {
                        char = activeChars[i];
                        if (char.y > stage.stageHeight) {
                            charContainer.removeChild( char );
                            activeChars.splice( i, 1 );
                            hiddenChars.push( char );
                        } else {            
                            char.refresh(this);
                        }
                    } catch(e:*) {
                        trace("MatrixCodeRain.refreshLabel");
                        trace(e);
                    }
                }
                
                if (activeChars.length < MatrixCodeRain.maxActiveChars) {
                    if ( hiddenChars.length > 0 ) {
                        char = hiddenChars.pop();
                        activeChars.push(char);
                        char.reset();
                    } else {
                        char = new MatrixCodeChar();
                        char.x = int(Math.random()*MatrixCodeRain.charPathWidth)*(stage.stageWidth/MatrixCodeRain.charPathWidth);
                        activeChars.push(char);
                    }
                    charContainer.addChild(char);
                }
            } catch(e:*) {
                trace("MatrixCodeRain.refresh");
                trace(e);
            }
        }
    }
    
}

import flash.display.Stage;
import flash.filters.GlowFilter;
import flash.text.AntiAliasType;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import MatrixCodeRain;

var activeStage:Stage = null;

 
class MatrixCodeChar extends TextField {

    private static var charTextFormat:TextFormat = new TextFormat(
        /*font*/"Consolas", /*size*/16, /*color*/0xffffff,
        /*bold*/false, /*italic*/false, /*underline*/false, /*url*/"",
        /*target*/"", /*align*/"left", /*leftMargin*/0, /*rightMargin*/0,
        /*indent*/0, /*leading*/4
    );
    private static var chars:Array = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZアイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヰヱヲンΓΔΘΛΠΣΦΨΩßƂƆƎƐƔÐƷƸƧℲЖИЛШЯѲѪ".split("");
    
    private var fallSpeed:Number;
    public var lastPrint:int;

    public function MatrixCodeChar() {
        try {
            this.height = 12;
            this.width = 12;
            this.multiline = false;
            this.wordWrap = false;                
            this.autoSize = TextFieldAutoSize.CENTER;
            this.antiAliasType = AntiAliasType.NORMAL;
            this.gridFitType = flash.text.GridFitType.PIXEL;
            this.defaultTextFormat = charTextFormat;
            this.reset();
        } catch(e:*) {
            trace("MatrixCodeChar");
            trace(e);
        }
    }

    public function refresh(parent:MatrixCodeRain):void {
        try {
            var moved:Boolean = Math.random() > 0.75;
            if ( Math.random() > 0.5 ) text = chars[int(Math.random() * 36) % 36];
            else if ( Math.random() > 0.5 ) text = chars[int((36 + (Math.random() * 48)) % 84)];
            else if ( Math.random() > 0.5 ) text = chars[int((84 + (Math.random() * 27)) % 111)];
            if ( moved && y > (lastPrint+(textHeight/2)) ) {
                lastPrint = y;
                parent.stampChar(this);
            }
            if ( moved ) y += fallSpeed;
        } catch(e:*) {
            trace("MatrixCodeChar.refresh");
            trace(e);
        }
    }

    public function reset():void {
        try {
            text = chars[ int(Math.random() * chars.length) % chars.length ];
            fallSpeed = 5 + (Math.random() * 11);
            x = int(Math.random() * MatrixCodeRain.charPathWidth) * (activeStage.stageWidth / MatrixCodeRain.charPathWidth);
            y = 0;
            lastPrint = int.MIN_VALUE;
        } catch(e:*) {
            trace("MatrixCodeChar.reset");
            trace(e);
        }
    }

}

var traceTxtField:TextField=new TextField();
traceTxtField.defaultTextFormat=new flash.text.TextFormat("courier",9,0xffffff);
traceTxtField.mouseEnabled=false;
traceTxtField.selectable=false;
traceTxtField.alpha=.8;
traceTxtField.autoSize = TextFieldAutoSize.LEFT;
var traceInitd:Boolean = false;

function trace(mess:*):void {
    if ( !traceInitd ) activeStage.addChild(traceTxtField);
    var txt:String = "";
    var s:Stage = traceTxtField.stage;
    txt += mess.toString()+"\n"
    if ( mess is Error ) {
        var st:String = mess.getStackTrace()
        if ( st !== null )
            txt += st+"\n";
    }
    while( traceTxtField.text.length > 1000 )
        traceTxtField.text = traceTxtField.text.substr( traceTxtField.text.indexOf('\r') + 1 );
    traceTxtField.appendText(txt);
    if (s === null) return;
    traceTxtField.y = s.stageHeight - traceTxtField.textHeight;
};
