/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1gZP
 */

// forked from shaktool's forked from: flash on 2013-11-26
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
	public class FlashTest extends Sprite
	{
		private var foreground: Graphics;
		private var rootNode: Node;
		public function FlashTest()
		{
			var sprite: Sprite;
			
			sprite = new Sprite();
			addChild( sprite );
			var background: Graphics = sprite.graphics;
			background.beginFill( 0x0077ff );
			background.drawRect( 0, 0, WIDTH, HEIGHT );
			background.endFill();
			
			sprite = new Sprite();
			addChild( sprite );
			foreground = sprite.graphics;
			
			var prevNode: Node = null;
			for ( var i: int = 0; i < 16; i++ )
			{
				var node: Node = new Node( new <Number>[ 0.5 * WIDTH, HEIGHT - i * JOINT_LENGTH ], prevNode, null );
				if ( i == 0 ) rootNode = node;
				if ( prevNode != null ) prevNode.next = node;
				prevNode = node;
			}
			
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame( event: Event = null ): void
		{
			var node: Node;
			rootNode.pos = new <Number>[ mouseX, mouseY ];
			var gravity: Vector.<Number> = new <Number>[ 0.0, 1.0 ];
			var wind: Vector.<Number> = new <Number>[ 5.0, 0.0 ];
			
			for ( node = rootNode.next; node != null; node = node.next )
			{
				var oldPos: Vector.<Number> = node.pos;
				node.pos = add( node.pos, node.vel );
				var offset: Vector.<Number> = subtract( node.prev.pos, node.pos );
				var distance: Number = vecLength( offset );
				if ( distance > JOINT_LENGTH )
				{
					var offsetScale: Number = ( distance - JOINT_LENGTH ) / distance;
					var change: Vector.<Number> = multiply( offset, offsetScale );
					node.pos = add( node.pos, change );
					node.prev.vel = subtract( node.prev.vel, multiply( change, 0.7 ) );
				}
				node.vel = subtract( node.pos, oldPos );
				var windDiff: Vector.<Number> = subtract( node.vel, wind );
				node.vel = subtract( node.vel, multiply( windDiff, Math.min( 1.0, 0.005 * vecLength( windDiff ) ) ) );
				node.vel = add( node.vel, gravity );
			}
			
			foreground.clear();
			for ( var i: int = 0; i < 10; i++ )
			{
				var start: Number = i * 10;
				foreground.moveTo( rootNode.pos[ 0 ] + start, rootNode.pos[ 1 ] );
				foreground.lineStyle( 2, 0xffffff );
				for ( node = rootNode.next; node != null; node = node.next )
				{
					foreground.lineTo( node.pos[ 0 ] + start, node.pos[ 1 ] );
				}
				foreground.lineStyle();
			}
		}
	}
}

const WIDTH: int = 465;
const HEIGHT: int = 465;
const JOINT_LENGTH: Number = 20.0;

class Node
{
	public var pos: Vector.<Number>;
	public var vel: Vector.<Number> = new <Number>[ 0.0, 0.0 ];
	public var prev: Node;
	public var next: Node;
	public function Node( pos: Vector.<Number>, prev: Node, next: Node )
	{
		this.pos = pos;
		this.prev = prev;
		this.next = next;
	}
}

function add( a: Vector.<Number>, b: Vector.<Number> ): Vector.<Number> { return new <Number>[ a[ 0 ] + b[ 0 ], a[ 1 ] + b[ 1 ] ]; }
function subtract( a: Vector.<Number>, b: Vector.<Number> ): Vector.<Number> { return new <Number>[ a[ 0 ] - b[ 0 ], a[ 1 ] - b[ 1 ] ]; }
function multiply( a: Vector.<Number>, b: Number ): Vector.<Number> { return new <Number>[ a[ 0 ] * b, a[ 1 ] * b ]; }
function vecLength( a: Vector.<Number> ): Number { return Math.sqrt( a[ 0 ] * a[ 0 ] + a[ 1 ] * a[ 1 ] ); }
function dot( a: Vector.<Number>, b: Vector.<Number> ): Number { return a[ 0 ] * b[ 0 ] + a[ 1 ] * b[ 1 ]; }
function SafeNormalize( a: Vector.<Number> ): Vector.<Number> { var len: Number = vecLength( a ); return len == 0.0 ? new <Number>[ 0.0, 0.0 ] : new <Number>[ a[ 0 ] / len, a[ 1 ] / len ]; }