/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1elL
 */

// forked from cjcat2266's 重力マウス（プチ軽量化：25万パーティクル）
// forked from clockmaker's 重力マウス（プチ軽量化：10万パーティクル）
// forked from coppieee's 重力マウス（さらに軽量化してみた）
// forked from paq's forked from: 重力マウス（ちょっぴり軽量化してみた）
// forked from fumix's 重力マウス（リンクリストにしてみた）
// forked from undo's 重力マウス
//　リンクリストにしてみたけどそんなに速くない？？
//_bmd.fillRect()を_bmd.setPixel()に変更。
//sin(),cos(),atan2(),sqrt()を排除。
// Add final class / mouseEnalbled = false by clockmaker
// CJ Cat: Used vector instead of linked list.
// clockmaker: while文の処理を4回コピペしてイテレーションの回数を減らす 100万で30fps (FP10.1 Release))
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.ByteArray;
    import net.hires.debug.Stats;

    [SWF(frameRate='48', width='465', height='465', backgroundColor='0x0')]

    public class Main extends Sprite {
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _bmdRect:Rectangle;
        private var _colorTransform:ColorTransform = new ColorTransform(0.97, 0.9, 0.9, 1.0);

        private const _maxNum:int = 1000000 * 4;
        private var _cnt:int = 0;
        
        private const _particleData:Vector.<Number> = new Vector.<Number>(_maxNum * 4, true);
        

        public function Main() {
            if(stage) init(null);
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(evt:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.quality = "low";
            this.mouseEnabled = false;
            this.mouseChildren = false;
        
            _bmd = new BitmapData(465, 465, false, 0x000000);
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
            this._bmdRect = _bmd.rect;
            
            var i0:int, i1:int, i2:int, i3:int;
            i0 = 0;
            
            while (i0 < _maxNum ) {
                i1 = i0;
                i2 = ++i1;
                i3 = ++i2;
                i3++;
                
                _particleData[i0] = Math.random() * 465 >> 0;
                _particleData[i1] = Math.random() * 465 >> 0;
                _particleData[i2] = 0;
                _particleData[i3] = 0;
                
                i0 = ++i3;
            }
            
            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, onEnter);
        }

        private function onEnter(evt:Event):void {
            var gravPoint_x:Number = mouseX;
            var gravPoint_y:Number = mouseY;
            var calc:Boolean = _cnt % 10 == 0;
            
            this._bmd.lock();
            
            
            var diff_x:Number, diff_y:Number, acc:Number, acc_x:Number, acc_y:Number;
            var i0:int, i1:int, i2:int, i3:int, j0:int, j1:int, j2:int, j3:int, k0:int, k1:int, k2:int, k3:int, l0:int, l1:int, l2:int, l3:int;
            i0 = 0;
            while (i0 < _maxNum)
            {
                i1 = i0;
                i2 = ++i1;
                i3 = ++i2;
                j0 = ++i3;
                j1 = ++j0;
                j2 = ++j1;
                j3 = ++j2;
                k0 = ++j3;
                k1 = ++k0;
                k2 = ++k1;
                k3 = ++k2;
                l0 = ++k3;
                l1 = ++l0;
                l2 = ++l1;
                l3 = ++l2;
                l3++;
                
                        
                if(calc){
                    diff_x = gravPoint_x - _particleData[i0];
                    diff_y = gravPoint_y - _particleData[i1];
                    acc = 400 / (diff_x * diff_x + diff_y * diff_y);
                    acc_x = acc * diff_x;
                    acc_y = acc * diff_y;
                    _particleData[i2] += acc * diff_x;
                    _particleData[i3] += acc * diff_y;
                    
                    diff_x = gravPoint_x - _particleData[j0];;
                    diff_y = gravPoint_y - _particleData[j1];
                    acc = 400 / (diff_x * diff_x + diff_y * diff_y);
                    acc_x = acc * diff_x;
                    acc_y = acc * diff_y;
                    _particleData[j2] += acc * diff_x;
                    _particleData[j3] += acc * diff_y;
                    
                    diff_x = gravPoint_x - _particleData[k0];;
                    diff_y = gravPoint_y - _particleData[k1];
                    acc = 400 / (diff_x * diff_x + diff_y * diff_y);
                    acc_x = acc * diff_x;
                    acc_y = acc * diff_y;
                    _particleData[k2] += acc * diff_x;
                    _particleData[k3] += acc * diff_y;
                    diff_x = gravPoint_x - _particleData[l0];;
                    diff_y = gravPoint_y - _particleData[l1];
                    acc = 400 / (diff_x * diff_x + diff_y * diff_y);
                    acc_x = acc * diff_x;
                    acc_y = acc * diff_y;
                    _particleData[l2] += acc * diff_x;
                    _particleData[l3] += acc * diff_y;
                }
                
                // 1 step
                _particleData[i0] += _particleData[i2];
                _particleData[i1] += _particleData[i3];
                _particleData[i2] *= 0.96;
                _particleData[i3] *= 0.96;
                this._bmd.setPixel(_particleData[i0] >> 0, _particleData[i1] >> 0, 0xffffff);
                
                
                // 2 step
                _particleData[j0] += _particleData[j2];
                _particleData[j1] += _particleData[j3];
                _particleData[j2] *= 0.96;
                _particleData[j3] *= 0.96;
                this._bmd.setPixel(_particleData[j0] >> 0, _particleData[j1] >> 0, 0xffffff);
                
                
                // 3 step
                _particleData[k0] += _particleData[k2];
                _particleData[k1] += _particleData[k3];
                _particleData[k2] *= 0.96;
                _particleData[k3] *= 0.96;
                this._bmd.setPixel(_particleData[k0] >> 0, _particleData[k1] >> 0, 0xffffff);
                
                
                // 4 step            
                _particleData[l0] += _particleData[l2];
                _particleData[l1] += _particleData[l3];                
                _particleData[l2] *= 0.96;
                _particleData[l3] *= 0.96;
                this._bmd.setPixel(_particleData[l0] >> 0, _particleData[l1] >> 0, 0xffffff);
                
                
                i0 = ++l3;
            }
            this._bmd.colorTransform(this._bmdRect, this._colorTransform);
            this._bmd.unlock();
            
            _cnt++;
        }
    }
}