/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1dkh
 */

package 
{
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    
    /**
     * 上のボタンは普通の音のファミマ入店音。
     * 下のボタンはファミコン音のファミマ入店音。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class FamiMart extends Sprite
    {
        private const familyNote: String = "t85;v4l8o6[ f+d>a<dea4.ef+e>a<d4.r8 ]2;v3l8o5[ r4f+4<c+4.>ea4a4f+4.r8 ]2;";
        private const famiNote: String = "t85;%1@7v8l8o6[ f+d>a<dea4.ef+e>a<d4.r8 ]2;%1@7v7l8o5[ r4f+4<c+4.>ea4a4f+4.r8 ]2;";
        private var family: SiONData;
        private var fami: SiONData;
        private var driver: SiONDriver;
        private var btn1: PushButton;
        private var btn2: PushButton;
        
        public function FamiMart() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            driver = new SiONDriver();
            family = driver.compile(familyNote);
            fami = driver.compile(famiNote);
            btn1 = new PushButton();
            btn1.label = "Family Mart Enter";
            addChild(btn1);
            btn1.x = (stage.stageWidth - btn1.width) / 2;
            btn1.y = (stage.stageHeight - btn1.width) / 2 - 50;
            btn1.addEventListener(MouseEvent.CLICK, onClickFamily);
            btn2 = new PushButton();
            btn2.label = "Fami Mart Enter";
            addChild(btn2);
            btn2.x = (stage.stageWidth - btn2.width) / 2;
            btn2.y = (stage.stageHeight - btn2.width) / 2 + 50;
            btn2.addEventListener(MouseEvent.CLICK, onClickFami);
        }
        
        private function onClickFami(e:MouseEvent):void 
        {
            if (driver.isPlaying) 
            {
                driver.stop();
                driver.play(fami);
            }
            else driver.play(fami);
        }
        
        private function onClickFamily(e:MouseEvent):void 
        {
            if (driver.isPlaying) 
            {
                driver.stop();
                driver.play(family);
            }
            else driver.play(family);
        }
        
    }

}