/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1dXD
 */

// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Brown extends Sprite {
        private var numDots:uint = 50;
        private var friction:Number  =0.95;
        private var dots:Array;
        
        public function Brown() {
            dots = new Array();
            for( var i:uint = 0; i < numDots; i++ ){
                var dot:Ball = new Ball( 1, 0 );
                dot.x = Math.random() * stage.stageWidth;
                dot.y = Math.random() * stage.stageHeight;
                dot.vx = 0;
                dot.vy = 0;
                addChild( dot );
                dots.push( dot );
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            for( var i:uint = 0; i < numDots; i++ ){
                var dot:Ball = dots[i];
                graphics.moveTo( dot.x, dot.y );
                graphics.lineStyle(0, Math.random() * 0xffffff );
                dot.vx += Math.random() * 0.5 - 0.25;
                dot.vy += Math.random() * 0.5 - 0.25;
                dot.x += dot.vx;
                dot.y += dot.vy;
                dot.vx *= friction;
                dot.vy *= friction;
                graphics.lineTo( dot.x, dot.y );
                
                if( dot.x > stage.stageWidth ){
                    dot.x = 0;
                } else if( dot.x < 0 ){
                    dot.x = stage.stageWidth;
                }
                
                if( dot.y > stage.stageHeight ){
                    dot.y = 0;
                } else if( dot.y < 0 ){
                    dot.y = stage.stageHeight;
                }

            }

        }

    }
}

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    public var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Ball(radius:Number=40, color:uint=0Xff0000){
        this.radius = radius;
        this.color = color;
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
}