/**
 * Copyright nishink ( http://wonderfl.net/user/nishink )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1dM2
 */

// 歩行キャラのサンプル
// 上下左右キーで歩きます
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.text.TextField;

	[SWF(width=256, height=256, backgroundColor=0)]
	public class FlashTest extends Sprite {
		// 画像のURL
		private const IMAGE_URL:String = "http://assets.wonderfl.net/images/related_images/0/0b/0b69/0b69a26f1f0c93107e34e9d098739dadef6cc3e1";

		private var loader:Loader = new Loader();
		private var field:Bitmap = new Bitmap(new BitmapData(256, 256, false, 0));
		private var key:Key = new Key();
		private var chara:Chara = new Chara();

		public function FlashTest() {
			// 画像を読み込みます
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
			loader.load(new URLRequest(IMAGE_URL), new LoaderContext(true));
			// 画像表示フィールドを登録
			addChild(field);
		}
		// 読み込み完了を待つ
		private function onComplete(ev:Event):void {
			// イベントリスナーの破棄
			loaderInfo.removeEventListener(Event.COMPLETE, onComplete);
			// 画像が読み込まれたので描画ＯＫ
			// イベントを登録します
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		// 描画更新
		private function onEnterFrame(ev:Event):void {
			chara.onEnterFrame(key, loader.content as Bitmap, field);
		}
		// キー押下
		private function onKeyDown(ev:KeyboardEvent):void {
			key.press(ev.keyCode);
		}
		// キー離す
		private function onKeyUp(ev:KeyboardEvent):void {
			key.release(ev.keyCode);
		}
	}
}
import flash.display.Bitmap;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.ui.Keyboard;
class Chara {
	private var dir:uint = 0;
	private var count:int = 0;
	private var pos:Point = new Point(0, 0);
	private var rect:Rectangle = new Rectangle(0, 0, 16, 16);
	private var clear:Rectangle = new Rectangle(0, 0, 16, 16);
	private var vx:int = 0;
	private var vy:int = 0;
	
	public function onEnterFrame(key:Key, bmp:Bitmap, field:Bitmap):void {
		// 描画する絵をどれにするかカウント
		count++;
		if (count >= 16) count = 0;
		// 描画する絵の判定（Ｘ方向）
		switch (count / 4) {
			case 0: rect.x = 0; break;
			case 1: rect.x = 16; break;
			case 2: rect.x = 0; break;
			case 3: rect.x = 32; break;
		}
		// 描画する絵の判定（Ｙ方向）
		vy = vx = 0;
		if (key.isPress(Keyboard.DOWN)) {
			rect.y = 0;
			vy = 1;
		} else if (key.isPress(Keyboard.UP)) {
			rect.y = 16;
			vy = -1;
		} else if (key.isPress(Keyboard.LEFT)) {
			rect.y = 32;
			vx = -1;
		} else if (key.isPress(Keyboard.RIGHT)) {
			rect.y = 48;
			vx = 1;
		}
		// 描画位置の更新
		clear.x = pos.x;
		clear.y = pos.y;
		pos.x += vx;
		pos.y += vy;
		// 描画
		field.bitmapData.lock();
		field.bitmapData.fillRect(clear, 0);
		field.bitmapData.copyPixels(bmp.bitmapData, rect, pos);
		field.bitmapData.unlock();
	}
}
class Key {
	private var state:Array = new Array();
	public function press(keyCode:uint):void {
		state[keyCode] = true;
	}
	public function release(keyCode:uint):void {
		state[keyCode] = false;
	}
	public function isPress(keyCode:uint):Boolean {
		return state[keyCode];
	}
}
