/**
 * Copyright esimov ( http://wonderfl.net/user/esimov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1d5p
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Shader;
    import flash.display.ShaderJob;
    import flash.display.Loader;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import mx.utils.*;
    
    import com.bit101.components.Panel;
    import com.bit101.components.Style;
    import com.bit101.components.Window;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Label;
    import com.bit101.components.HUISlider;
    
    [SWF (background = 0x00, width = "465", height = "465")]

    public class Monjori extends Sprite
    {
        private var _imageURL:String;
        private var _shaderJob:ShaderJob;
        private var _imageLoader:Loader;
        private var _bmpData:BitmapData;
        private var _bmp:Bitmap;
        private var _dec64:Base64Decoder;
            
        private var _shader:Shader;
        private var _window:Window;
        private var _red:HUISlider;
        private var _green:HUISlider
        private var _blue:HUISlider;
        
        private var dec64:String = "";
        private var time:Number = 0;        
        private const WIDTH:Number = stage.stageWidth;
        private const HEIGTH:Number = stage.stageHeight;
        
        public function Monjori():void
        {
            initStage();
        }
        
        private function initStage():void
        {
            if (stage) init(null);
            else
            {
                throw new Error("Stage not active");
                addEventListener(Event.ADDED_TO_STAGE, init);
            }
        }
        
        private function init(event:*):void
        {
             stage.align = StageAlign.TOP_LEFT;
             //stage.scaleMode = StageScaleMode.NO_SCALE;
             stage.quality = "medium";
             stage.frameRate = 60;
                        
            dec64 += "pQEAAACkBwBNb25qb3JpoAxuYW1lc3BhY2UAU2ltbyBFbmRyZQCgDHZlbmRvcgBzaW1vZW5k";
            dec64 += "cmUud29yZHByZXNzLmNvbQCgCHZlcnNpb24AAQCgDGRlc2NyaXB0aW9uAFBpeGVsYmVuZGVy";
            dec64 += "IGFkYXB0ZWQgdmVyc2lvbiBvZiBNaWMncyAxayBkZW1vLnJlbGVhc2UAoQECAAAMX091dENv";
            dec64 += "b3JkAKEBAQAAAnRpbWUAogFtaW5WYWx1ZQAAAAAAogFtYXhWYWx1ZQBGHEAAogFkZWZhdWx0";
            dec64 += "VmFsdWUAAAAAAKIMZGVzY3JpcHRpb24AYWRqdXN0IHRpbWUAoQECAQAMcmVzb2x1dGlvbgCi";
            dec64 += "Am1pblZhbHVlAELIAABCyAAAogJtYXhWYWx1ZQBEgAAAREAAAKICZGVmYXVsdFZhbHVlAERI";
            dec64 += "AABEFgAAogxkZXNjcmlwdGlvbgBkZWZpbmUgdGhlIHNjcmVlbiByZXNvbHV0aW9uAKEBAwIA";
            dec64 += "DmNvbG9yAKIDbWluVmFsdWUAPczMzT3MzM09zMzNogNtYXhWYWx1ZQBBoAAAQaAAAEGgAACi";
            dec64 += "A2RlZmF1bHRWYWx1ZQA/pmZmQQAAAEFgAACiDGRlc2NyaXB0aW9uAGFkanVzdCAxc3QgY29s";
            dec64 += "b3IAoQIDAwAOZHN0ADIAABC/gAAAMgEAIEAAAAAdBADBAQCgAAMEAMEAABAABAEAMQEAEAAD";
            dec64 += "AQAxBAAQAB0EAMEAAPAAAQQAwQEAsAAdAQAxBAAQADIAABBBoAAAHQIAEAAAgAADAgAQAADA";
            dec64 += "AB0AABACAMAAMgIAEDzMzM0yAwAQQ8gAADIEAIA/AAAAHQQAQAEAgAADBABABAAAADIEAIA/";
            dec64 += "AAAAHQQAIAQAQAABBAAgBAAAAB0EAIADAMAAAwQAgAQAgAAdAwAQBAAAADIEAIBDyAAAMgQA";
            dec64 += "QD8AAAAdBAAgAQDAAAMEACAEAEAAMgQAQD8AAAAdBAAQBACAAAEEABAEAEAAHQQAQAQAAAAD";
            dec64 += "BABABADAAB0EAIAEAEAAMgQAQEMgAAAdBAAgAwDAAAMEACACAMAAMgQAEEMWAAAEBQCABADA";
            dec64 += "AAMFAIAAAMAAHQQAEAQAgAABBAAQBQAAAAwEACAEAMAAMgQAEEGgAAAdBQCABACAAAMFAIAE";
            dec64 += "AMAAHQQAIAQAQAABBAAgBQAAAB0EAEAEAIAAMgQAIEMgAAAdBAAQBAAAAAMEABACAMAAMgUA";
            dec64 += "gEAAAAAEBQBABQAAAAMFAEAEAMAADQQAEAUAQAAyBQCAQZAAAB0FAEAEAMAAAwUAQAUAAAAd";
            dec64 += "BAAQBACAAAEEABAFAEAAHQQAIAMAwAADBAAgAgDAAA0FAIAEAIAAMgQAIEDgAAAdBQBABQAA";
            dec64 += "AAMFAEAEAIAAHQQAIAQAwAABBAAgBQBAAB0EABAEAIAAHQQAIAQAQAACBAAgAwDAADIFAIBA";
            dec64 += "AAAAHQUAQAQAgAAHBQBABQAAAB0EACAEAMAAAgQAIAQAAAAyBQCAQAAAAB0FACAEAIAABwUA";
            dec64 += "IAUAAAAdBAAgBQBAAAEEACAFAIAAFgUAgAQAgAAdBAAgBQAAAAQFAIAEAIAAAwUAgAQAAAAd";
            dec64 += "BQBABQAAAA0FAIAFAEAAHQUAIAQAgAADBQAgBQAAADIFAIBAAAAABAUAEAUAAAADBQAQAADA";
            dec64 += "AB0FAIAFAIAAAgUAgAUAwAAdAwAQBQAAAAwFAIAFAEAAHQUAIAQAgAADBQAgBQAAADIFAIBA";
            dec64 += "AAAABAUAEAUAAAADBQAQAADAAB0FAIAFAIAAAgUAgAUAwAAdBACABQAAAB0FAIADAMAAAwUA";
            dec64 += "gAIAwAAMBQAgBQAAADIFAIBDMAAAHQUAEAUAgAADBQAQBQAAAB0FAIADAMAAAwUAgAIAwAAM";
            dec64 += "BQAgBQAAADIFAIBDJAAAHQYAgAUAgAADBgCABQAAAB0FAIAFAMAAAQUAgAYAAAAdBQAgBQAA";
            dec64 += "AAEFACAEAIAAHQQAEAUAgAAdBQCABAAAAAEFAIAEAMAAMgUAIEAAAAAEBQAQBQCAAAMFABAA";
            dec64 += "AMAAHQUAIAUAAAABBQAgBQDAAB0FAIAFAIAAAwUAgAIAwAAdBQAgBQAAAB0FAIAEAIAAAwUA";
            dec64 += "gAEAgAAyBQAQP6ZmZgQGAIAFAMAAAwYAgAUAAAAdBQCABQCAAAEFAIAGAAAADQUAEAUAAAAd";
            dec64 += "BQCAAwDAAAEFAIADAMAAHQYAgAUAAAABBgCAAADAAB0FAIAFAMAAAwUAgAYAAAAdBQAQBQBA";
            dec64 += "AAMFABACAMAAMgYAgEGQAAAdBgBABQDAAAMGAEAGAAAADQUAEAYAQAAyBgCAQEAAAAQGAEAG";
            dec64 += "AAAAAwYAQAUAgAAdBgCABACAAAEGAIAGAEAAHQYAQAUAwAADBgBABgAAAB0FABAFAAAAAQUA";
            dec64 += "EAYAQAAdBABABQDAAB0FAIAEAAAAAwUAgAIAwAAMBQAQBQAAADIFAIBCMAAAHQYAgAUAwAAD";
            dec64 += "BgCABQAAAB0FAIADAMAAAwUAgAIAwAAMBQAQBQAAADIFAIBDVAAAHQYAQAUAwAADBgBABQAA";
            dec64 += "AB0FAIAGAEAAAwUAgAEAgAAdBQAQBgAAAAIFABAFAAAAHQUAIAUAwAAdBQCABAAAAAIFAIAD";
            dec64 += "AMAAHQUAEAUAAAADBQAQBQBAAB0FAIAFAIAAAQUAgAUAwAAdBQAQAADAAAEFABAFAIAAMgYA";
            dec64 += "gEDgAAAEBgBABgAAAAMGAEAFAMAAHQUAEAQAgAACBQAQBgBAAAwGAIAFAMAAMgUAEEEgAAAd";
            dec64 += "BgBABgAAAAMGAEAFAMAAHQUAEAUAAAABBQAQBgBAADIFAIBAgAAABAYAgAUAAAADBgCABABA";
            dec64 += "AB0FAIAFAMAAAQUAgAYAAAAdBQAQBQAAAAMFABACAMAAHQUAIAUAwAAyBQCAQBMzMx0FABAF";
            dec64 += "AIAAAwUAEAUAAAAyBQCAQ68AAAQGAIAFAAAAAwYAgAAAwAAdBQCABgAAAAIFAIAFAEAADAYA";
            dec64 += "gAUAAAAdBQCABQDAAAMFAIAGAAAADQUAEAUAAAAyBQCAQzgAAB0GAIAFAMAAAwYAgAUAAAAy";
            dec64 += "BQCAQImZmh0FABAEAIAAAwUAEAUAAAAyBQCAQUAAAAQGAEAFAAAAAwYAQAAAwAAdBQCABQDA";
            dec64 += "AAEFAIAGAEAAHQUAEAUAAAADBQAQAgDAAB0FAIAFAEAAAgUAgAUAwAAMBQAQBQAAAB0FAIAG";
            dec64 += "AAAAAwUAgAUAwAAdBQAQBACAAAMFABACAMAAHQYAgAUAwAABBgCABQCAAA4FABAGAAAAMgYA";
            dec64 += "gEM4AAAdBgBABQDAAAMGAEAGAAAAHQUAEAQAgAADBQAQAgDAAB0GAIAFAMAAAQYAgAUAgAAN";
            dec64 += "BQAQBgAAAB0GAIAGAEAAAwYAgAUAwAAdBQAQBQAAAAEFABAGAAAAAQQAQAUAwAAyBQCAQLMz";
            dec64 += "MwQFABAFAAAAAwUAEAQAQAAyBQCAQ4AAAB0GAIAFAMAACAYAgAUAAAAyBQCAQoAAAAQFABAF";
            dec64 += "AAAAAwUAEAYAAAAdBABABQDAADIFAIAAAAAAKgQAQAUAAAAdAYCAAIAAADQAAAABgAAAMgUA";
            dec64 += "gECAAAABBABABQAAADYAAAAAAAAAMgUAgEAAAAArBQCABABAAB0BgIAAgAAANAAAAAGAAAAy";
            dec64 += "BQCAQIAAAB0FABAFAAAAAgUAEAQAQAAdBABABQDAADYAAAAAAAAAMgUAgEN6AAAEBQAQBQAA";
            dec64 += "AAMFABAEAIAAHQQAEAUAwAAdBQCABADAAAMFAIAEAMAAMgUAEEEAAAAdBgCABQAAAAMGAIAF";
            dec64 += "AMAADAUAgAYAAAAyBQAQPwUeuB0GAIAFAAAAAwYAgAUAwAABBAAQBgAAAB0FAIAAAMAAAwUA";
            dec64 += "gAIAwAAMBQAQBQAAADIFAIA/gAAAHQYAgAUAwAABBgCABQAAADIFAIBAAAAABAUAEAUAAAAD";
            dec64 += "BQAQBgAAAB0EAIAFAMAAHQUAgAQAAAADBQCABABAAAQFABACAAAAAwUAEAUAAAAdBgCABQDA";
            dec64 += "ADIFAIBAoAAABAUAEAUAAAADBQAQBABAADIFAIBBAAAABAYAEAUAAAADBgAQBADAAB0FAIAF";
            dec64 += "AMAAAQUAgAYAwAAdBgBABQAAAB0GACAEAEAAHQcA4gYAGAADBwDiBAD8AB0GAOIHABgAAwYA";
            dec64 += "4gEAqAAEBQCAAgAAAAMFAIAEAEAABAUAEAIAQAADBQAQBADAAB0GABAFAAAAAQYAEAUAwAAd";
            dec64 += "BwCABgDAADIFAIA/TMzNBAUAEAUAAAADBQAQBABAAAQFAIACAIAAAwUAgAQAwAAdBgAQBQDA";
            dec64 += "AAEGABAFAAAAHQcAQAYAwAAdBwAgBABAAB0IAOIHABgAAwgA4gQA/AAyBQCAQBmZmh0FABAF";
            dec64 += "AAAAAgUAEAEAgAAdBwDiCAAYAAMHAOIFAPwAHQgA4gYAGAABCADiBwAYAB0GAOIIABgAHQcA";
            dec64 += "gAYAAAAdBwBABgCAAB0HACAGAEAAHQMA4gcAGAA=";

            _bmpData = new BitmapData(WIDTH/2, HEIGTH/2, false, 0x00);
            _bmp = new Bitmap(_bmpData);
            _bmp.smoothing = false;
            _bmp.scaleX = _bmp.scaleY = 2;
            _bmp.filters = [new BlurFilter(2,2)];
            addChild(_bmp);
            
            controlPanel();
            
            _dec64 = new Base64Decoder;
            _dec64.decode(dec64);
            _shader = new Shader(_dec64.drain());
            
            _shader.data.resolution.value = [WIDTH/1.2, HEIGTH/1.2];
            _shader.data.color.value = [_red.value, _green.value, _blue.value];
            
            addEventListener(Event.ENTER_FRAME, loop);
            
        }
                
        private function controlPanel():void
        {        
            _window = new Window(this, WIDTH - 100, 0, "Effect adjuster");
            _window.draggable = true;
            _window.hasMinimizeButton = false;
            _window.width = 120;
            _window.height = 100;
            addChild(_window);
            
            var redLabel:Label = new Label(_window, 1, 30, "R: ");
            var greenLabel:Label = new Label(_window, 1, 50, "G: ");
            var blueLabel:Label = new Label(_window, 1, 70, "B: ");
            _red = new HUISlider(_window, 8, 30, null);
            _red.width = _window.width;
            _red.tick = 0.01;
            _red.setSliderParams(0.1, 20.0, 1.3);
            _green = new HUISlider(_window, 8, 50, null);
            _green.width = _window.width;
            _green.tick = 0.01;
            _green.setSliderParams(0.1, 20.0, 8.0);
            _blue = new HUISlider(_window, 8, 70, null);
            _blue.width = _window.width;
            _blue.tick = 0.01;
            _blue.setSliderParams(0.1, 20.0, 14.0);
        }
        
        private function loop(event:Event):void
        {
            _shaderJob = new ShaderJob(_shader, _bmpData);
            _shaderJob.start();
            
            time += 0.095;
            _shader.data.time.value = [time];
            _shader.data.color.value = [_red.value, _green.value, _blue.value];
        }
    }
}

/***********************
 * Pixelbender Shader
***********************/

/* Credits goes to Inigo Quilez
 * http://www.iquilezles.org/apps/shadertoy/
 */

/*<languageVersion : 1.0;>

kernel Monjori
<   namespace : "Simo Endre";
    vendor : "simoendre.wordpress.com";
    version : 1;
    description : "Pixelbender adapted version of Mic's 1k demo.release";
>

{
    parameter float time
    <
        minValue:     float(0.0);
        maxValue:     float(10000.0);
        defaultValue: float(0.0);
        description:  "adjust time";
    >;      
    
    parameter float2 resolution
    <
        minValue:     float2(100.0, 100.0);
        maxValue:     float2(1024.0, 768.0);
        defaultValue: float2(800.0, 600.0);
        description:  "define the screen resolution";
    >;  
    
    parameter float3 color
    <
        minValue:     float3(0.1, 0.1, 0.1);
        maxValue:     float3(20.0, 20.0, 20.0);
        defaultValue: float3(1.3, 8.0, 14.0);
        description:  "adjust 1st color";
    >;
    
    
    input image4 src;
    output pixel3 dst; 
    
    void evaluatePixel()
    {
        float2 p = -1.0 + 2.0 * outCoord().xy / resolution.xy;
        float a = time*20.0;
        float d,e,f,g=1.0/40.0,h,i,r,q;
        e=400.0*(p.x*0.5+0.5);
        f=400.0*(p.y*0.5+0.5);
        i=160.0+sin(e*g+a/150.0)*20.0;
        d=160.0+cos(f*g/2.0)*18.0+cos(e*g)*7.0;
        r=sqrt(pow(i-e,2.0)+pow(d-f,2.0));
        q=f/r;
        e=(r*cos(q))-a/2.0;f=(r*sin(q))-a/2.0;
        d=sin(e*g)*176.0+sin(e*g)*164.0+r;
        h=((f+d)+a/2.0)*g;
        i=cos(h+r*p.x/1.3)*(e+e+a)+cos(q*g*18.0)*(r+h/3.0);
        h=sin(f*g)*44.0-sin(e*g)*212.0*p.x;
        h=(h+(f-e)*q+sin(r-(a+h)/7.0)*10.0+i/4.0)*g;
        i+=cos(h*2.3*sin(a/350.0-q))*184.0*sin(q-(r*4.3+a/12.0)*g)+tan(r*g+h)*184.0*cos(r*g+h);
        i=mod(i/5.6,256.0)/64.0;
        if(i<0.0) i+=4.0;
        if(i>=2.0) i=4.0-i;
        d=r/250.0;
        d+=sin(d*d*8.0)*0.52;
        f=(sin(a*g)+1.0)/2.0;
        
        float3 col = float3(f*i/color.r,i/5.0+d/8.0,i)*d*p.x+float3(i/color.r+d/color.g,i/0.8+d/color.b,i)*d*(2.4-p.x);
        
        dst.rgb = float3(col.r, col.b, col.g);

    }
}*/
