/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1cGw
 */

package {
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.events.Event;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.events.InteractiveScene3DEvent;
    
    public class Main extends BasicView {
        private var frontMat:ColorMaterial; // 正面のマテリアル
        private var backMat:ColorMaterial; // 背面のマテリアル 
        private var otherMat:ColorMaterial; // その他の面のマテリアル
        private var cube:Cube;
        private var label:Label;
        
        public function Main() {
            // ４番目のinteractiveプロパティーをtrueにする
            super(0, 0, true, true);
            
            // マテリアルを作成 (本当は6面作りますが、省略のため3つだけ・・・)
            frontMat = new ColorMaterial(0xFF0000);
            frontMat.interactive = true;
            
            backMat = new ColorMaterial(0x00FF00);
            backMat.interactive = true;
            
            otherMat = new ColorMaterial(0xEEEEEE);
            otherMat.interactive = true;
            
            // マテリアルズリストに登録
            var ml:MaterialsList = new MaterialsList( {
                front: frontMat,
                back : backMat,
                left : otherMat,
                right : otherMat,
                top : otherMat,
                bottom : otherMat
            });
            
            // cube作成
            cube = new Cube(ml);
            scene.addChild(cube);
            
            // イベント
            cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, clickHandler);
            
            // いろいろ
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
            // トレース用
            label = new Label(this, 10, 10, "");
        }
        
        private function clickHandler(e:InteractiveScene3DEvent):void {
            // renderHitDataのmaterialでクリックしたときの面の参照が取れる
            trace(e.renderHitData.material);
            
            // あとはif文なりswitch文なりでどうぞ！
            switch(e.renderHitData.material) {
                case frontMat:
                    trace("正面をクリックしたときのイベント");
                    label.text = "CLICK - FRONT";
                    break;
                    
                case backMat:
                    trace("背面をクリックしたときのイベント");
                    label.text = "CLICK - BACK";
                    break;
                    
                case otherMat:
                    trace("その他の面をクリックしたときのイベント");
                    label.text = "CLICK - OTHER";
                    break;
            }
        }
        
        // エンターフレームでCubeを回しておく
        private function loop(e:Event):void {
            cube.rotationY += 3;
        }
    }
}