/**
 * Copyright kske ( http://wonderfl.net/user/kske )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1c33
 */

package {
    import flash.events.Event;
    import flash.text.TextFieldAutoSize;
    import flash.display.DisplayObject;
    import flash.text.TextFormat;
    import flash.display.Graphics;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.display.MovieClip;
    import flash.display.Sprite;

    /**
     * 東京ひよこの復習。野中先生のAS2風onRelease, onReleaseOutsideを実装してみつつ色々発表にあったネタを仕込んでみたよ。
     */
    [SWF(width = "500", height = "320", frameRate = "30")]
    public class ReleaseButton extends Sprite{
        private var button:MovieClip;
        private var text:TextField;
        private var releaseTarget:DisplayObject;
        public function ReleaseButton():void{
            setPrototype();
            initButton();
            initText();
        }

        private function initText() : void {
            text = new TextField;
            var format:TextFormat = new TextFormat();
            
            format.size = 16;
            
            text.autoSize = TextFieldAutoSize.LEFT;
            text.defaultTextFormat = format;
            text.text = "";
            
            addChild(text);
        }

        private function setPrototype():void{
            DisplayObject.prototype.onRelease = function(e:MouseEvent):void{};
            DisplayObject.prototype.onReleaseOutside = function(e:MouseEvent):void{};
            // prototypeでプロパティを拡張。MCだけに適用するなら無くてもいい
            // 間違って呼び出したときのために空のfunctionを入れておく（値チェックでもよし
        }
        
        private function initButton():void{
            var hit:Sprite = createHitArea();
            
            button = new MovieClip();
            button.addChild(hit);
            button.hitArea = hit;
            // hitAreaプロパティにSpriteを入れてマウスに反応する範囲を設定
            setButtonLabel(button);
            button.buttonMode = true;
            button.mouseChildren = false;
            // mouseChildredをfalseにしてMCだけがマウスイベントを受けるように
            
            button.x = Math.floor((stage.stageWidth - 100) / 2);
            button.y = Math.floor((stage.stageHeight - 20) / 2);
            
            button.onRelease = function(e:MouseEvent):void{
                text.text = "onRelease: " + releaseTarget.name;
                releaseTarget = null;
            };
            button.onReleaseOutside = function(e:MouseEvent):void{
                text.text = "onReleaseOutside: " + releaseTarget.name;
                releaseTarget = null;
            };
            // MovieClipはdynamic classなのでprototype拡張が警告だけで通る
            
            
            button.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            addChild(button);
        }

        private function onMouseDown(e: MouseEvent) : void {
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            releaseTarget =  e.currentTarget as DisplayObject;
        }

        private function onMouseUp(e: MouseEvent) : void {
            if(!releaseTarget) return;
            
            if( e.target == releaseTarget){
                (releaseTarget as DisplayObject)["onRelease"](e);
                (releaseTarget as DisplayObject).dispatchEvent(new Event("onReleaseMouse"));
            }else{
                (releaseTarget as DisplayObject)["onReleaseOutside"](e);
                (releaseTarget as DisplayObject).dispatchEvent(new Event("onReleaseMouseOutside"));
            }
            // DisplayObjectはstatic classなのでハッシュアクセスじゃないとコンパイルが通らない
            // 今回はAS2風にしたけど、dispatchEventさせてもいいかも？ ちゃんとやるならEventじゃなくてMouseEventを自前で作る
        }

        private function createHitArea() : Sprite {
            var s:Sprite = new Sprite;
            var g:Graphics = s.graphics;
            g.beginFill(0x0);
            g.drawRoundRect(0, 0, 100, 20, 5);
            g.endFill();
            return s;
        }

        private function setButtonLabel(b:MovieClip):void{
            var label:TextField = new TextField();
            var format:TextFormat = new TextFormat();
            format.color = 0xffffff;
            format.size = 14;
            label.defaultTextFormat = format;
            label.text = "button";
            // フォーマットの設定の順番で色々あるらしい
            
            label.x = 30;
            
            b.addChild(label);
            b.label = label;
        }
    }
}
