/**
 * Copyright noonat ( http://wonderfl.net/user/noonat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1bgH
 */

// Logger class is defined at the bottom of the file.
// It's log method smarty converts params to string and
// concatenates them, like so:
// _logger.log('mouse is at x=', mouseX, ', y=', mouseY);

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	public class LoggerTest extends Sprite {
		private const MARGIN:int = 16;
		private const WIDTH:int = 32;
		private var _bitmapData:BitmapData;
		private var _pixels:Array = [
			1,0,0,0,0,1,1,1,
			0,0,0,0,1,1,1,1,
			0,0,0,1,1,1,1,0,
			0,0,1,1,1,1,0,0,
			0,1,1,1,1,0,0,0,
			1,1,1,1,0,0,0,0,
			1,1,1,0,0,0,0,1,
			1,1,0,0,0,0,1,1];
		private var _logger:Logger;
		
		function LoggerTest():void {
			_render();
			_logger = addChild(new Logger()) as Logger;
			stage.addEventListener(Event.RESIZE, function(e:Event):void { _render(); });
			stage.addEventListener(MouseEvent.CLICK, function(e:Event):void {
				_logger.log('clicked at', mouseX, ',', mouseY);
			})
			_logger.log('hello, world!');
                        _logger.log('this is a demo of the logger');
                        _logger.log('it logs strings and other vars, like the number', 10, 'to your movie');
                        _logger.log('text is logged into this translucent overlay');
		}
		
		internal function _render():void {
			if (!_bitmapData) {
				stage.align = StageAlign.TOP_LEFT;
				stage.scaleMode = StageScaleMode.NO_SCALE;
				_bitmapData = new BitmapData(8, 8);
				for (var i:int=0; i < _pixels.length; ++i) {
					if (!_pixels[i]) continue;
					_bitmapData.setPixel32(i%8, Math.floor(i/8), 0xff999999);
				}
			}
			graphics.beginFill(0xffffffff);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			graphics.beginBitmapFill(_bitmapData);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
		}
	}
}

import flash.display.BlendMode;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class Logger extends Sprite {
	private var _textField:TextField;
	
	function Logger():void {
		super();
		visible = false;
		_textField = addChild(new TextField()) as TextField;
                _textField.alpha = 0.8;
		_textField.autoSize = TextFieldAutoSize.LEFT;
                _textField.background = true;
                _textField.backgroundColor = 0x000000;
                //_textField.blendMode = BlendMode.LAYER;
		_textField.defaultTextFormat = new TextFormat('Arial', 12, 0xffffff, true);
	}
	
	public function log(... args):void {
		visible = true;
		var buffer:Array = [];
		for (var i:int=0; i < args.length; ++i) buffer.push(String(args[i]));
		_textField.appendText((_textField.text !== '' ? '\n' : '') + buffer.join(' '));
		if (height > stage.stageHeight) y = stage.stageHeight - height;
	}
}
