/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1bY5
 */

// forked from clockmaker's [PV3D] Fireworks
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.geom.*;
	import flash.filters.*;
	
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	import org.papervision3d.view.*;
	import org.papervision3d.view.layer.*;
	import org.papervision3d.core.render.filter.*;
	import org.papervision3d.core.effects.*;
	import org.papervision3d.core.effects.utils.*;
	import org.papervision3d.core.math.Number3D;
	
	import caurina.transitions.Tweener;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#001020")]
	
	public class Main extends BasicView
	{	
		private var bfx:BitmapEffectLayer;
		
		/**
		 * Constructor
		 */
		public function Main()
		{
			// init
			super(0, 0, true, false, CameraType.TARGET);
			
			// create the effect layer
			bfx = new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE);
			bfx.addEffect(new BitmapLayerEffect( new BlurFilter(2, 2, 1)));
			bfx.addEffect(new BitmapColorEffect(1.2, 1.15, 1.1, .95));
			bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 1, 0.5), BlendMode.ADD);
			bfx.drawLayer.blendMode = BlendMode.ADD;
			viewport.containerSprite.addLayer(bfx);
			
			// update
			var timer:Timer = new Timer(2000);
			timer.addEventListener(TimerEvent.TIMER, timerHandler);
			timer.start();
			
			// create the Field
			var field:Plane = new Plane(new WireframeMaterial(0xFFFFFF, .25), 5000, 5000, 5, 5);
			field.rotationX = 90;
			scene.addChild(field);
			
			// init camera
			camera.y = 100;
			camera.z = -1000;
			camera.focus = 400;
			camera.zoom = 1;
                        var target:DisplayObject3D = new DisplayObject3D;
                        target.y = 500;
                        camera.target = target;
                        
                        // rotate angle
			stage.addEventListener(Event.ENTER_FRAME, function(event:Event):void
			{
				camera.target.x = -(stage.stageWidth/2 - stage.mouseX);
				camera.target.y = 500+(stage.stageHeight/2 - stage.mouseY);
			});
			
			// render
			startRendering();
		}
		
		/**
		 * Timer Handler - Give Fireworks
		 * @param	event
		 */
		private function timerHandler(event:TimerEvent):void
		{
			var fireworks:DisplayObject3D = createFireworks();
			fireworks.x = Math.random() * 500 - 250;
			fireworks.z = Math.random() * 500 - 250;
			fireworks.y = Math.random() * 250 + 750;
			
			scene.addChild(fireworks);
			
			Tweener.addTween(fireworks,
			{
				y          : fireworks.y  - 200,
				time       : 4,
				transition : "easeInSine"
			});
		}
		
		/**
		 * Create Fireworks
		 * @return Fireworks(DisplayObject3D)
		 */
		private function createFireworks():DisplayObject3D
		{
			var fireworks :DisplayObject3D = new DisplayObject3D();
			
			var points:Array = getSpherePoints(300, 150);
			
			var color:uint = Math.random() * 0xFFFFFF;
			
			for (var i:int = 0; i < points.length; i++ )
			{
				var mat:ColorMaterial = new ColorMaterial(color);
				mat.doubleSided = true;
				
				var particle:Plane = new Plane(mat, 5, 5, 1, 1);
				
				fireworks.addChild(particle);
				
				bfx.addDisplayObject3D(particle);
				
				Tweener.addTween(particle,
				{
					x     : points[i].x,
					y     : points[i].y,
					z     : points[i].z,
					time  : 3 + Math.random() * .5,
					transition : "easeOutCubic",
					onCompleteParams : [particle],
					onComplete : function(p:Plane):void
					{
						fireworks.removeChild(p);
						bfx.removeDisplayObject3D(p);
					}
				});
			}
			
			return fireworks;
		}
		
		/**
		 * Get Points of sphere
		 * @param	size
		 * @param	numPoints
		 * @return  point of shphere
		 */
		private function getSpherePoints(size:int, numPoints:int = 100):Array
		{
			var points:Array = [];
			
			for (var i:uint = 0; i < numPoints; i++) {
                            var point:Number3D;
                            // reject points outside sphere bounds
                            while( point == null || point.modulo > 0.5 ) {
                                point = new Number3D(
                                    Math.random()-0.5,
                                    Math.random()-0.5,
                                    Math.random()-0.5
                                );
                            }
                            point.normalize();
                            point.multiplyEq( size );
			    points.push( point );
                        }
			
			return points;
		}

	}
}