/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1YE0
 */

package {
    import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.display.Graphics;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
    public class FlashTest extends Sprite {
		private const _8bit:uint = 0x000000FF;
		private const _16bit:uint = 0x0000FFFF;
		private const _24bit:uint = 0x00FFFFFF;
		private const _32bit:uint = 0xFFFFFFFF;
		
		private const COUNT:int = 1000000;
		
		private var txt:TextField;
        public function FlashTest() {
            // write as3 code here..
            txt = new TextField();
			txt.autoSize = "left";
			addChild(txt);
			
			var spr:Sprite = createBtn("one more test", 0, 400);
			
			addChild(spr);
			
			spr.addEventListener(MouseEvent.CLICK, test);
			
			test(null);
        }
		
		private function test(e:MouseEvent):void 
		{
			var bytes:ByteArray = new ByteArray();
			var time:int;
			var i:int;
			var ptr:uint;
			
			txt.text = "テスト回数 " + COUNT + "";
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				bytes[0] = _8bit;
			}
			txt.appendText("\nbytes[0] = _8bit : " + (getTimer() - time) + " msec");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				bytes[0] = _16bit;
			}
			txt.appendText("\nbytes[0] = _16bit : " + (getTimer() - time) + " msec");
			txt.appendText("\n============================");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				bytes.writeShort(_16bit);
			}
			txt.appendText("\nbytes.writeShort(_16bit) "+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			ptr = 0;
			while (i--)
			{
				bytes[ptr] = _16bit & 0xFF;
				ptr++;
				bytes[ptr] = _16bit >> 8;
				ptr++;
			}
			txt.appendText("\nポインタ移動で16bitずつ書込"+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			txt.appendText("\n============================");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				bytes.writeShort(_24bit);
				bytes.writeByte(_24bit >> 16);
			}
			txt.appendText("\nwriteShortとwriteByteで24bitずつ書込"+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			ptr = 0;
			while (i--)
			{
				bytes[ptr] = _24bit & 0xFF;
				ptr++;
				bytes[ptr] = (_24bit >> 8) & 0xFF;
				ptr++;
				bytes[ptr] = _24bit >> 16;
				ptr++;
			}
			txt.appendText("\nポインタ移動で24bitずつ書込"+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			txt.appendText("\n============================");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				bytes.writeUnsignedInt(_32bit);
			}
			txt.appendText("\nwriteUnsignedIntで32bitずつ書込"+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			ptr = 0;
			while (i--)
			{
				bytes[ptr] = _32bit & 0xFF;
				ptr++;
				bytes[ptr] = (_32bit >> 8) & 0xFF;
				ptr++;
				bytes[ptr] = (_32bit >> 16) & 0xFF;
				ptr++;
				bytes[ptr] = _32bit >> 24;
				ptr++;
			}
			txt.appendText("\nポインタ移動で32bitずつ書込"+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			txt.appendText("\n============================");
			
			time = getTimer();
			i = COUNT;
			var u:uint;
			while (i--)
			{
				u = _32bit;
			}
			txt.appendText("\nuint 32bitアクセス : " + (getTimer() - time) + " msec");
			txt.appendText("\n============================");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				u = _8bit + (_8bit << 8) + (_8bit << 16) + (_8bit << 24);
				bytes.writeUnsignedInt(u);
			}
			txt.appendText("\nuintに8bit変数4つで32bit作ってからwriteUnsignedInt"+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			txt.appendText("\n============================");
			
			bytes.clear();
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				u = _16bit + (_16bit << 16);
				bytes.writeUnsignedInt(u);
			}
			txt.appendText("\nuintに16bit変数2つで32bit作ってからwriteUnsignedInt"+bytes.length+"byte書込 : " + (getTimer() - time) + " msec");
			txt.appendText("\n============================");
		}
        
        private function createBtn(str:String, x:int, y:int):Sprite
        {
            var txt:TextField = new TextField();
            var spr:Sprite = new Sprite();
            txt.autoSize = "left";
            txt.textColor = 0xFFFFFF;
            txt.text = str;
            txt.selectable = false;
            spr.addChild(txt);
            var g:Graphics = spr.graphics;
            g.beginFill(0, 1);
            g.drawRect(0, 0, spr.width, spr.height);
            g.endFill();
            
            spr.x = x;
            spr.y = y;
            
            addChild(spr);
            
            return spr;
        }
    }
}