/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1XtU
 */

package 
{ 
    import flash.text.engine.*; 
    import flash.ui.Mouse; 
    import flash.display.Sprite 
    import flash.events.MouseEvent; 
    import flash.events.EventDispatcher; 
     
    public class EventHandlerExample extends Sprite 
    { 
        private var textBlock:TextBlock = new TextBlock(); 
 
        public function EventHandlerExample():void 
        { 
            var str:String = "I'll change color if you click me."; 
            var fontDescription:FontDescription = new FontDescription("Arial"); 
            var format:ElementFormat = new ElementFormat(fontDescription, 18); 
            var textElement:TextElement = new TextElement(str, format); 
            textBlock.content = textElement; 
            createLine(textBlock); 
        } 
     
        private function createLine(textBlock:TextBlock):void 
        { 
            var textLine:TextLine = textBlock.createTextLine(null, 500); 
            textLine.x = 30; 
            textLine.y = 30; 
            addChild(textLine); 
            textLine.addEventListener("mouseOut", mouseOutHandler); 
            textLine.addEventListener("mouseOver", mouseOverHandler); 
            textLine.addEventListener("click", clickHandler); 
        } 
 
        private function mouseOverHandler(event:MouseEvent):void 
        { 
            Mouse.cursor = "button"; 
        } 
 
        private function mouseOutHandler(event:MouseEvent):void 
        { 
            Mouse.cursor = "arrow"; 
        } 
 
        private function clickHandler(event:MouseEvent):void { 
            if(textBlock.firstLine) 
                removeChild(textBlock.firstLine); 
            var newFormat:ElementFormat = textBlock.content.elementFormat.clone(); 
            switch(newFormat.color) 
            { 
                case 0x000000: 
                    newFormat.color = 0xFF0000; 
                    break; 
                case 0xFF0000: 
                    newFormat.color = 0x00FF00; 
                    break; 
                case 0x00FF00: 
                    newFormat.color = 0x0000FF; 
                    break; 
                case 0x0000FF: 
                    newFormat.color = 0x000000; 
                    break; 
            } 
            textBlock.content.elementFormat = newFormat; 
            createLine(textBlock); 
        } 
    }
}