/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1XcK
 */

package {
  import flash.display.Sprite;
  import flash.text.TextField;

  import funnel.*;
  import funnel.ui.*;

  public class Debounce extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // ボタン
    private var button:Button;

    // カウントを表示するテキストフィールド
    private var textField:TextField;

    // ボタンを押したカウント
    private var count:int = 0;

    public function Debounce() {
      // ボタンを接続するピンのモードを入力に設定
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(8, IN);
      arduino = new Arduino(config);

      // ボタンのインスタンスを生成してイベントリスナをセット
      button = new Button(arduino.digitalPin(8));
      button.debounceInterval = 50;
      button.addEventListener(ButtonEvent.PRESS, 
                              onButtonPress);

      // テキストフィールドを生成して追加
      textField = new TextField();
      textField.text = "Count: 0";
      addChild(textField);
    }

    // ボタンが押される度に以下を実行
    private function onButtonPress(e:ButtonEvent):void {
      // カウントを1だけ増やして表示を更新
      count = count + 1;
      textField.text = "Count: " + count;
    }
  }
}
