/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1XV5
 */

// forked from shaktool's Peak beta 2
// forked from shaktool's Peak
// borrowed some code from psyark's BumpyPlanet:
// http://wonderfl.kayac.com/code/d79cd85845773958620f42cb3e6cb363c2020c73

package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.utils.*;
	
	[SWF(width=465, height=465, frameRate=24, backgroundColor=0x000000)]
	public class Peak extends Sprite {
		private const WIDTH: int = 465;
		private const HEIGHT: int = 465;
		private const MAX: int = 255;
		private const MIN: int = 0;
		private const WHITE: uint = 0xffffff;
		private const GRAY:  uint = 0x777777;
		private const BLACK: uint = 0x000000;
		
		
		private var paintMap: BitmapData = new BitmapData(WIDTH, HEIGHT, false, BLACK);
		private var heatMap1: BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);
		private var heatMap2: BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);
		private var flipMap1: BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);
		private var flipMap2: BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);
		private var colorMap: BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);
		
		private var display: Bitmap;
		
		private var mouseIsDown: Boolean = false;
		private var mouseColor: uint = WHITE;
		
		public function Peak() {
			stage.align = StageAlign.BOTTOM;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			//generate(null)
			//stage.addEventListener(MouseEvent.CLICK, generate);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			display = new Bitmap(colorMap);
			addChild(display);
			//addChild(new Bitmap(paintMap));
		}
		
		public function onKeyDown(event: KeyboardEvent): void {
			switch (String.fromCharCode(event.charCode)) {
				case "a":
					if (display.bitmapData == colorMap) display.bitmapData = paintMap; else display.bitmapData = colorMap;
					break;
				case "s":
					mouseColor = BLACK; break;
				case "d":
					mouseColor = GRAY; break;
				case "f":
					mouseColor = WHITE; break;
			}
		}
		
		public function onMouseDown(event: MouseEvent): void {
			mouseIsDown = true;
			onMouseMove(event);
		}
		
		public function onMouseUp(event: MouseEvent): void {
			mouseIsDown = false;
		}
		
		public function onMouseMove(event: MouseEvent): void {
			if (!mouseIsDown) return;
			for (var j: int = mouseY - 4; j <= mouseY + 4; j++) {
				for (var i: int = mouseX - 4; i <= mouseX + 4; i++) {
					paintMap.setPixel32(i, j, mouseColor);
				}
			}
		}
		
		public function generate(event: MouseEvent): void {
			var i: int;
			
			paintMap.fillRect(new Rectangle(0,0,WIDTH,HEIGHT), 0)
			for (i = 0; i < 20; i++) {
				paintMap.setPixel32(Math.random() * WIDTH, Math.random() * HEIGHT, WHITE);
				paintMap.setPixel32(Math.random() * WIDTH, Math.random() * HEIGHT, BLACK);
			}
			//heatMap1.fillRect(new Rectangle(0,0,WIDTH,HEIGHT), 0)
		}
		
		private function onEnterFrame(event: Event): void {
			flipMap1.lock();
			flipMap2.lock();
			colorMap.lock();
			
			for (var j: int = 0; j < HEIGHT; j++) {
				var row1: int = (j == 0) ? HEIGHT - 1 : j - 1;
				var row2: int = j;
				var row3: int = (j == HEIGHT - 1) ? 0 : j + 1;
				
				var sample1Top: uint;
				var sample1Left: uint;
				var sample1Center: uint;
				var sample1Right: uint;
				var sample1Bottom: uint;
				var sample2Top: uint;
				var sample2Left: uint;
				var sample2Center: uint;
				var sample2Right: uint;
				var sample2Bottom: uint;
				sample1Center = heatMap1.getPixel(WIDTH-1, row2);
				sample1Right  = heatMap1.getPixel(0, row2);
				sample2Center = heatMap2.getPixel(WIDTH-1, row2);
				sample2Right  = heatMap2.getPixel(0, row2);
				
				for (var i: int = 0; i < WIDTH; i++) {
					var nextCol: int = (i == WIDTH-1) ? 0 : i+1;
					sample1Top    = heatMap1.getPixel(i, row1);
					sample1Left   = sample1Center;
					sample1Center = sample1Right;
					sample1Right  = heatMap1.getPixel(nextCol, row2);
					sample1Bottom = heatMap1.getPixel(i, row3);
					sample2Top    = heatMap2.getPixel(i, row1);
					sample2Left   = sample2Center;
					sample2Center = sample2Right;
					sample2Right  = heatMap2.getPixel(nextCol, row2);
					sample2Bottom = heatMap2.getPixel(i, row3);
					
					var pixelSource: uint = paintMap.getPixel(i, row2);
					var pixel1: uint;
					var pixel2: uint;
					if (pixelSource == WHITE) {
						pixel1 = 0;
						pixel2 = 0xffffff;
					} else if (pixelSource == BLACK) {
						pixel1 = 0xffffff;
						pixel2 = 0;
					} else {
						pixel1 = sample1Top;
						if (sample1Left < pixel1)   pixel1 = sample1Left;
						if (sample1Center < pixel1) pixel1 = sample1Center;
						if (sample1Right < pixel1)  pixel1 = sample1Right;
						if (sample1Bottom < pixel1) pixel1 = sample1Bottom;
						if (pixel1 < 0xffffff) pixel1++;
						pixel2 = sample2Top;
						if (sample2Left < pixel2)   pixel2 = sample2Left;
						if (sample2Center < pixel2) pixel2 = sample2Center;
						if (sample2Right < pixel2)  pixel2 = sample2Right;
						if (sample2Bottom < pixel2) pixel2 = sample2Bottom;
						if (pixel2 < 0xffffff) pixel2++;
					}
					
					flipMap1.setPixel(i, j, pixel1);
					flipMap2.setPixel(i, j, pixel2);
					
					var color: Number = pixel2 / (pixel1 + pixel2);
					var colorPixel: uint = color * 255;
					colorPixel = (colorPixel << 16) + (colorPixel << 8) + (colorPixel << 0)
					colorMap.setPixel(i, j, colorPixel);
				}
			}
			
			flipMap1.unlock();
			flipMap2.unlock();
			colorMap.unlock();
			
			var tempMap: BitmapData = heatMap1;
			heatMap1 = flipMap1;
			flipMap1 = tempMap;
			tempMap = heatMap2;
			heatMap2 = flipMap2;
			flipMap2 = tempMap;
			//display.bitmapData = colorMap;
		}
	}
}