/**
 * Copyright mas ( http://wonderfl.net/user/mas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1XUQ
 */

package {
	import flash.display.*;
	import flash.events.Event;
	import flash.geom.*;
	[SWF (width = "480", height = "480", backgroundColor = "0xffffff", framerate = "60")]
    public class Bezier3D extends Sprite {
		private var _seqment:BezierSegment3D;
		
		private var _startIdx:int;
		private var _endIdx:int;
		
		private var _d:Vector3D;
		
		private var _dx:Number, _dy:Number;
		private var _numCopy:int;
		
		public var verts:Vector.<Number>;
		public var tVerts:Vector.<Number>;
		public var pVerts:Vector.<Number>;
		public var uvt:Vector.<Number>;
		private var _colors:Vector.<int>;
		
		private var _m:Matrix3D;
		private var _proj:Matrix3D;
		
		private var rot:Number;
		
		private var _container:Sprite;
		
        	public function Bezier3D() {
            // write as3 code here..
			verts = new Vector.<Number>;
			tVerts = new Vector.<Number>;
			pVerts = new Vector.<Number>;
			uvt = new Vector.<Number>;
			_colors = new Vector.<int>;
			
			_d = new Vector3D;
			
			initialize();
			
			_m = new Matrix3D;
			var perspective:PerspectiveProjection = new PerspectiveProjection;
			perspective.fieldOfView = 60;
			_proj = perspective.toMatrix3D();
			
			_container = new Sprite;
			_container.x = stage.stageWidth / 2;
			_container.y = stage.stageHeight / 2;
			addChild(_container);
			
			_dx = 0;
			_dy = 0;
			
			var i:int;
			var c:int;
			for (i = 0; i <= 50; i++)
			{
				c = 100 + i * 3;
				_colors.push(c << 16 | c * 0.6 << 8 | (255 - c * 0.6));
			}
			
			addEventListener(Event.ENTER_FRAME, update);
        }
		
		private function initialize():void
		{
			_startIdx=0;
			_endIdx = 0;
			
			_numCopy = 3 + int(7 * Math.random());
			
			var func:Function = function():Number
			{
				return (Math.random() - 0.5) * 0.4;
			};
			
			var a:Vector3D = _d;
			var b:Vector3D = new Vector3D(func(), func(), func());
			var c:Vector3D = new Vector3D(func(), func(), func());
			_d = new Vector3D(func(), func(), func());
			
			_seqment = new BezierSegment3D(a, b, c, _d);
			
			verts.length = 0;
			
			var i:int;
			var v:Vector3D;
			for (i = 0; i <= 50; i++)
			{
				v = _seqment.getValue(i / 50);
				verts.push(v.x, v.y, v.z);
			}
		}
		
		private function update(e:Event):void
		{
			_dx += (-stage.mouseX - _dx) * 0.1;
			_dy += (-stage.mouseY - _dy) * 0.1;
				
			_container.graphics.clear();
			
			var j:int;
			for (j = 0; j < _numCopy; j++)
			{
				_m.identity();
				_m.appendRotation(j * 360 / _numCopy, Vector3D.Z_AXIS);
				_m.appendRotation(_dy, Vector3D.X_AXIS);
				_m.appendRotation(_dx, Vector3D.Y_AXIS);
				_m.appendTranslation(0, 0, 0.5);
				_m.transformVectors(verts, tVerts);
				Utils3D.projectVectors(_proj, tVerts, pVerts, uvt);
				
				var i:int;
				var len:int = pVerts.length / 2;
				
				for (i = _startIdx; i < _endIdx - 1; i++)
				{
					_container.graphics.lineStyle(10, _colors[i], 0.8, false, "normal", CapsStyle.NONE);
					_container.graphics.moveTo(pVerts[i * 2], pVerts[i * 2 + 1]);
					_container.graphics.lineTo(pVerts[(i + 1) * 2 + 0], pVerts[(i + 1) * 2 + 1]);
				}
			}
			
			if (_endIdx != len)
			{
				_endIdx++;
			}
			else
			{
				_startIdx++;
				if (_startIdx == len - 1)	initialize();
			}
		}
    }
}
import flash.geom.Vector3D;
class BezierSegment3D
{
	public var a:Vector3D;
	public var b:Vector3D;
	public var c:Vector3D;
	public var d:Vector3D;
		
	public function BezierSegment3D($a:Vector3D, $b:Vector3D, $c:Vector3D, $d:Vector3D) 
	{
		a = $a;
		b = $b;
		c = $c;
		d = $d;
	}
		
	public function getValue($t:Number):Vector3D
	{
		var t:Number = $t;
		var ret:Vector3D = new Vector3D;
		ret.x = a.x * Math.pow((1 - t), 3) + 3 * b.x * t * Math.pow((1 - t), 2) + 3 * c.x * Math.pow(t, 2) * (1 - t) + d.x * Math.pow(t, 3);
		ret.y = a.y * Math.pow((1 - t), 3) + 3 * b.y * t * Math.pow((1 - t), 2) + 3 * c.y * Math.pow(t, 2) * (1 - t) + d.y * Math.pow(t, 3);
		ret.z = a.z * Math.pow((1 - t), 3) + 3 * b.z * t * Math.pow((1 - t), 2) + 3 * c.z * Math.pow(t, 2) * (1 - t) + d.z * Math.pow(t, 3);
			
		return ret;
	}
}