/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1XJJ
 */

package {
    import flash.display.*;
    import flash.text.*;
    import flash.events.Event;
    import flash.geom.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.utils.*;
    import org.papervision3d.events.*;
    import org.papervision3d.materials.*;
	import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
	import org.papervision3d.typography.*;
	import org.papervision3d.typography.fonts.*;
    import org.papervision3d.view.BasicView;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
    
    [SWF(backgroundColor="0xffffff", frameRate="60")]
    public class GuessFont extends BasicView {
        private static const TEMP : String = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"; // 出題元
        private static const NPLANE : uint = 15; // プレートの数
        private var _tf : TextField; // デバッグ用
        
        // プレート
        private var _planesQ : Array;
        private var _planesC : Array;
        
        // プレートのなかのTextFieldたち
        private var _tfsQ : Array;
        private var _tfsC : Array;
        
        private var _tScore : Text3D; // スコア表示用
        private var _shCorrect : Shape; // 正解表示用緑色フィルタ
        
        private var _fonts : Array = Font.enumerateFonts(true);
        
        private var _correct : int = 0; // 正解数
        private var _all : int = 0; // 問題数

        private var _indAns : int = -1; // 正解インデックス
        private var _stage : int = 0; // 現在問題を表示しているインデックス
        
        private var _step : int = Math.random() * -99999999; // 時刻
        private var _param : Object = {thetaC : 0.0, thetaQ : 0.0}; // プレートの追加回転パラメータ
        
        private var _dTarg : DisplayObject3D = new DisplayObject3D(); // 視線の先設定用
        		
        public function GuessFont() {
            super(0, 0, true, true);
            
            // 問題プレートをy軸まわりに作成
        		_planesQ = [];
        		_tfsQ = [];
        		var i : uint;
        		for(i = 0;i < NPLANE;i++){ 
	            var sprQ : Sprite = new Sprite();
	            var shQ : Shape = new Shape();
	            shQ.graphics.beginFill(0xff0000);
	            shQ.graphics.drawRect(0, 0, 100, 100);
	            shQ.graphics.endFill();
	            shQ.alpha = 0.3;
	            sprQ.addChild(shQ);
	            
	            var tfQ : TextField = new TextField();
	            tfQ.autoSize = "center";
	            sprQ.addChild(tfQ);
	        		_tfsQ.push(tfQ);
	            
	        		var mmQ : MovieMaterial = new MovieMaterial(sprQ, true, true, false);
	        		mmQ.doubleSided = true;
	        		mmQ.smooth = true;
	        		
        			var p : Plane = new Plane(mmQ, 30, 30);
        			
        			scene.addChild(p);
        			_planesQ.push(p);
        		}
        		
        		// 選択肢プレートをz軸まわりに作成
           	_planesC = [];
           	_tfsC = [];
        		for(i = 0;i < NPLANE * 3;i++){
        			var sprC : Sprite = new Sprite();
            		var shC : Shape = new Shape();
           		shC.graphics.beginFill(0x0000ff);
           		shC.graphics.drawRect(0, 0, 200, 100);
        		    shC.graphics.endFill();
            		shC.alpha = 0.3;
            		sprC.addChild(shC);
            
            		var tfC : TextField = new TextField();
           		tfC.defaultTextFormat = new TextFormat("arial", 12);
           		tfC.wordWrap = true;
           		tfC.multiline = true;
           		sprC.addChild(tfC);
           		_tfsC.push(tfC);
            
	        		var mmC : MovieMaterial = new MovieMaterial(sprC, true, true, false, new Rectangle(0, 0, 120, 60));
        			mmC.doubleSided = true;
        			mmC.smooth = true;
        			p = new Plane(mmC, 20, 10);
        			
        			scene.addChild(p);
        			_planesC.push(p);
        		}
            
            // スコア表示用Text3Dを作成
       		var lm : Letter3DMaterial = new Letter3DMaterial(0x000000, 0.8);
       		lm.doubleSided = true;
        		_tScore = new Text3D("Guess Font!", new HelveticaBold(), lm);
        		_tScore.scale = 0.3;
        		scene.addChild(_tScore);
            
            // デバッグ用
            _tf = new TextField();
//            addChild(_tf);
            _tf.width = 100;
            _tf.height = 465;
            
            // カメラはx軸正から原点を見る
            camera.x = 200;
            camera.y = 0;
            camera.z = 0;
            _dTarg.x = 0;
            _dTarg.y = 0;
            _dTarg.z = 0;
        		camera.lookAt(_dTarg); 
            
            // 最初のカメラ移動
            BetweenAS3.tween(camera, 
            	{x:200, y:0, z:0},
            	{x:1, y:0, z:0},
            	1.1
            	).play();
    			
    			// 選択肢プレート全部に対してイベントリスナを立てておく        
			for(i = 0;i < NPLANE * 3;i++){
				_planesC[i].addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onObjectClick);
			}
			
			// 正解フィルタの作成
          	_shCorrect = new Shape();
          	_shCorrect.graphics.beginFill(0x33ff33);
       		_shCorrect.graphics.drawRect(0, 0, 200, 100);
        		_shCorrect.graphics.endFill();
          	_shCorrect.alpha = 0.5;
            					
            startRendering();
       
			onObjectClick();
        }
        
        private function onObjectClick(e : InteractiveScene3DEvent = null) : void
        {
        		var i : uint;
        		if(e != null){
				for(i = _stage * 3;i < _stage * 3 + 3;i++){
					_planesC[i].material.interactive = false;
				}
				
	        		// 正解フィルタを正解プレートにaddChild
	        		_planesC[_indAns].material.movie.addChild(_shCorrect);
	        		
	        		// スコア更新
	        		var cind : int = _planesC.indexOf(e.target);
				if(_indAns == cind){
					_correct++;
		        }
		        _all++;
		        _tScore.text = _correct + "/" + _all;
		        _tScore.scale = 0.7;
        		}
    			
    			// 一定時間経過後プレートをまわす
    			BetweenAS3.delay(
				BetweenAS3.serial(
					BetweenAS3.func(function() : void
					{
						// 新しい問題を作成する
						var q : String = TEMP.charAt(Math.random() * TEMP.length);
						var qind : int = int(Math.random() * TEMP.length);
						_tfsQ[_stage].defaultTextFormat = new TextFormat(_fonts[qind].fontName, 85);
						_tfsQ[_stage].text = q;
						_indAns = _stage * 3 + int(Math.random() * 3);
						
						var inds : Array = [qind];
						for(i = _stage * 3;i < _stage * 3 + 3;i++){
							_planesC[i].material.interactive = true;
							if(i == _indAns){
								_tfsC[i].text = _fonts[qind].fontName;
							}else{
								do{
									var ind : uint = uint(Math.random() * _fonts.length);
								}while(inds.indexOf(ind) > -1);
								_tfsC[i].text = _fonts[ind].fontName;
							}
						}
					}),
					// プレートを回す
					BetweenAS3.to(_param, {
						thetaC : _param.thetaC - Math.PI * 2 / NPLANE,
						thetaQ : _param.thetaQ - Math.PI * 2 / NPLANE
						}, 1.0, Cubic.easeInOut)
				),
				0.7).play();
				
			_stage++;
			if(_stage == NPLANE)_stage = 0;
        }
        
        override protected function onRenderTick(e : Event = null) : void
        {
        		var i : uint;
        		var theta : Number;
        		
        		// 問題プレートの配置
        		// なぜか原点向きにするとちゃんと表示される
    			_dTarg.x = 0;
    			_dTarg.y = Math.cos(_step * 0.003) * 5;
    			_dTarg.z = 0;
        		for(i = 0;i < NPLANE;i++){
        			theta = i / NPLANE * Math.PI * 2 - 0.1 + Math.cos(_step * 0.005) * 0.02 + _param.thetaQ;
        			_planesQ[i].x = 150 * Math.cos(theta);
        			_planesQ[i].y = Math.cos(_step * 0.006) * 3;
        			_planesQ[i].z = 150 * Math.sin(theta);
        			_planesQ[i].lookAt(_dTarg);
        		}
        		
        		// 選択肢プレートの配置
    			_dTarg.x = 0;
    			_dTarg.y = 0;
    			_dTarg.z = 15 + Math.cos(_step * 0.006) * 3; 
        		for(i = 0;i < NPLANE * 3;i++){
        			theta = i / (NPLANE * 3) * Math.PI * 2 - 0.16 + Math.cos(_step * 0.01) * 0.02 + _param.thetaC;
        			_planesC[i].x = 150 * Math.cos(theta);
        			_planesC[i].y = 150 * Math.sin(theta);
        			_planesC[i].z = 15 + Math.cos(_step * 0.006) * 3;
        			_planesC[i].lookAt(_dTarg);
        		}
        		
        		// スコア表示Text3Dの配置
        		_tScore.x = 0;
        		_tScore.y = Math.cos(_step * 0.003) * 70;
        		_tScore.z = 0;
        		_tScore.rotationY -= 0.3;
        		
        		_step++;
            super.onRenderTick(e);
        }
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}
