/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1X06
 */

package {
    import flash.display.*;
    [SWF(backgroundColor=0x000000, frameRate=60)]
    public class Qb2D extends MovieClip {
        import com.actionsnippet.qbox.*;
        import Box2D.Common.Math.*;
        
        private var sim:QuickBox2D;
        public function Qb2D() {
            
          code();
        }
        
        // procedural code
        private function code():void{
            var sim:QuickBox2D = new QuickBox2D(this, {debug:false,gravityY:10, renderJoints:false});
    sim.setDefault({fillColor:0xCC0000,lineAlpha:0});
sim.createStageWalls();

sim.addPoly({x:7, y:10, angle:0.1, verts:[[0,0,2,1,-2,1],[0.5,.9,0,1.2,-0.5,.9]]});
  
sim.setDefault({fillColor:0xEFEFEF, fillAlpha:0.5, lineColor:0xFFFFFF, groupIndex:-2});
var ancA:QuickObject = sim.addCircle({x:20, y:12, radius:0.5, density:0, skin:"none"});
var ancB:QuickObject = sim.addCircle({x:20, y:2, radius:0.5, density:0, skin:"none"});
var head:QuickObject = sim.addCircle({x:0, y:-0.6, radius:0.5});
var neck:QuickObject = sim.addBox({x:0, y:1, width:0.5, height:2});
var spindle:QuickObject = sim.addBox({x:0, y:3, width:0.1, height:2})
spindle.userData.visible = false;
var top:QuickObject = sim.addGroup({objects:[head, neck, spindle], x:10, y:5, fixedRotation:true});
var upperLegA:QuickObject = sim.addBox({x:10, y:7.5, width:0.25, height:1.5});
var lowerLegA:QuickObject = sim.addBox({x:10, y:9, width:0.25, height:1.5});
var wheel:QuickObject = sim.addCircle({x:10, y:9, radius:1});
var upperLegB:QuickObject = sim.addBox({x:10, y:7.5, width:0.25, height:1.5});
var lowerLegB:QuickObject = sim.addBox({x:10, y:9, width:0.25, height:1.5});
var upperArmA:QuickObject = sim.addBox({x:10.7, y:5.25, width:1.5, height:0.25});
var lowerArmA:QuickObject = sim.addBox({x:11.8, y:5.25, width:1.2, height:0.25});
var upperArmB:QuickObject = sim.addBox({x:9.5, y:5.25, width:1.5, height:0.25});
var lowerArmB:QuickObject = sim.addBox({x:8.4, y:5.25, width:1.2, height:0.25});
var anchor:b2Vec2 = new b2Vec2();
function connect(a:QuickObject, b:QuickObject, lower:Number, upper:Number, offX:Number=0, offY:Number = 0):QuickObject{
	 var min:Number = Math.min(a.y, b.y);
	 var max:Number = Math.max(a.y, b.y);
	 anchor.y = min + (max - min) * 0.5 + offY;
	 min = Math.min(a.x, b.x);
	 max = Math.max(a.x, b.x);
	 anchor.x = min + (max - min) * 0.5 + offX;
	 return sim.addJoint({type:"revolute", a:a.body, b:b.body, x1:anchor.x, y1:anchor.y, lowerAngle:lower, upperAngle:upper});
}
sim.addJoint({type:"revolute", a:wheel.body, b:top.body, x1:wheel.x, y1:wheel.y});
sim.addJoint({type:"revolute", a:lowerLegA.body, b:wheel.body, x1:lowerLegA.x, y1:lowerLegA.y + 0.7});
sim.setDefault({enableLimit:true});
connect(top, upperArmA, 0, 3, -.3, .1);
connect(upperArmA, lowerArmA, -2.5, -1, 0, 0);
connect(top, upperArmB, -3, 0, .3, .1);
connect(upperArmB, lowerArmB, -2.5, -1, 0, 0);
sim.addJoint({type:"distance", a:lowerArmA.body, b:ancA.body, frequencyHz:0.3});
sim.addJoint({type:"distance", a:lowerArmB.body, b:ancB.body, frequencyHz:0.3});
sim.setDefault({enableLimit:true});
connect(top, upperLegA, -6.28, 6, 0, 0.8);
connect(upperLegA, lowerLegA, .1, 6);
wheel.angle = Math.PI;
connect(top, upperLegB, -6.28, 6, 0, 0.8);
connect(upperLegB, lowerLegB, .1, 6);
sim.setDefault({enableLimit:false, type:"revolute"});
sim.addJoint({a:lowerLegB.body, b:wheel.body, x1:lowerLegB.x, y1:lowerLegB.y + 0.7});
sim.start();
sim.mouseDrag();
var sd:Number = 5, s:Number = 0, t:Number = 0;
sim.addEventListener(QuickBox2D.STEP, function():void{
	top.angle = Math.cos(t += 0.05) * 0.2;
	 
	if (top.x> 12) sd = -5
	if (top.x <4) sd = 5;
	s += (sd - s) / 8;
	wheel.body.SetAngularVelocity(s);
});
}
    }
}