/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1WeE
 */

 
//inspired by http://wonderfl.net/c/nkeq
//inspired by http://beautifl.net/?c=particle

package {
    import flash.display.Stage;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.ui.Keyboard;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import com.greensock.*;
    import com.greensock.easing.*;
        
    public class Microcosm extends Sprite   {

        private var space:Sprite = new Sprite();
        private var spaceCanvas:BitmapData;
        private var lineSpace:Sprite = new Sprite();      
        private var mouseSx:Number;
        private var mouseSy:Number;
        private var mouseDx:Number;
        private var mouseDy:Number;
        private var mouseDownBool:Boolean;
        private var enterBool:Boolean;
        private var spaceBool:Boolean;       
        private var dx:Number=0;
        private var dy:Number=0;
        private var pvx:Number;
        private var pvy:Number;       
        private var _zeroPoint:Point;

        public function Microcosm() {
            pvx=mouseX;
            pvy=mouseY;
            addChild(space);
            addChild(lineSpace);
            space.graphics.beginFill(0x111111);
            space.graphics.drawRect(0,0,465,465);
            lineSpace.graphics.lineStyle(1,0xaa0000);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,mouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP,mouseUp);
            stage.addEventListener(KeyboardEvent.KEY_UP,keyUp);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyDown);           
            addEventListener(Event.ENTER_FRAME,enterFrame);
        }
        
        private function enterFrame(e:Event):void
        {            
//          space.BitmapData.applyFilter( space, space.rect, _zeroPoint, _blurFilter );
//          _canvas.colorTransform( space.rect, _alphaTransform );
//          _zeroPoint = new Point;
       
            for(var i:int = 0; i < space.numChildren; ++i){
                
                for(var j:int = i+1; j < space.numChildren; ++j){
                    if(distance(Planet(space.getChildAt(i)),Planet(space.getChildAt(j))) > Planet(space.getChildAt(i)).r + Planet(space.getChildAt(j)).r){
                        gravity(Planet(space.getChildAt(i)),Planet(space.getChildAt(j)));
                    }
                    else{
                        fusionPlanet(Planet(space.getChildAt(i)),Planet(space.getChildAt(j)));
                    }

                }
                if(!Planet(space.getChildAt(i)).blackhole){
                    
                    Planet(space.getChildAt(i)).x += Planet(space.getChildAt(i)).pX/Planet(space.getChildAt(i)).m;
                    Planet(space.getChildAt(i)).y += Planet(space.getChildAt(i)).pY/Planet(space.getChildAt(i)).m;
                }
                else{
                    Planet(space.getChildAt(i)).x = mouseX;
                    Planet(space.getChildAt(i)).y = mouseY;
                }

               
                /*
                if(Planet(space.getChildAt(i)).x > 465){
                    Planet(space.getChildAt(i)).x = 465;
                    Planet(space.getChildAt(i)).pX *= -0.9;
                }
                else if(Planet(space.getChildAt(i)).x < 0){
                    Planet(space.getChildAt(i)).x = 0;
                    Planet(space.getChildAt(i)).pX *= -0.9;
                }
                if(Planet(space.getChildAt(i)).y > 465){
                    Planet(space.getChildAt(i)).y = 465;
                    Planet(space.getChildAt(i)).pY *= -0.9;
                }
                else if(Planet(space.getChildAt(i)).y < 0){
                    Planet(space.getChildAt(i)).y = 0;
                    Planet(space.getChildAt(i)).pY *= -0.9;
                }
                */
                Planet(space.getChildAt(i)).pX += (232.5-Planet(space.getChildAt(i)).x)/100;
                Planet(space.getChildAt(i)).pY += (232.5-Planet(space.getChildAt(i)).y)/100;
                
                if(!spaceBool && Planet(space.getChildAt(i)).blackhole) space.removeChildAt(i);
            }
            dx = mouseX-pvx;
            dy = mouseY-pvy;
            pvx=mouseX;
            pvy=mouseY;
            
            if(enterBool) createPlanet(mouseX,mouseY,1,0,0,false);
        }
        
        private function gravity(a:Planet, b:Planet):void{
            var f:Number = (a.m*b.m)/((a.x-b.x)*(a.x-b.x) + (a.y-b.y)*(a.y-b.y));
            var r:Number = Math.atan2(b.y-a.y,b.x-a.x);
            
            a.pX += 10*f*Math.cos(r);
            b.pX -= 10*f*Math.cos(r);
            a.pY += 10*f*Math.sin(r);
            b.pY -= 10*f*Math.sin(r);
            
        }

         
       public function createPlanet(ix:Number,iy:Number,im:Number,ipX:Number,ipY:Number,blackhole:Boolean):void{
            var p:Planet = new Planet(im,ipX,ipY,blackhole);
            p.x = ix;
            p.y = iy; 
            p.scaleX = 10;
            p.scaleY = 10;
            p.blendMode = "add";
            space.addChild(p);
           
        //    TweenMax.to(p, 0, {colorTransform:{tint:0xffffff*Math.random(), tintAmount:0.5, exposure:2, brightness:0.5}, ease:Quad.easeOut});
            TweenMax.to(p, 0, {glowFilter:{color:0xFFFFFF*Math.random(), alpha:1, blurX:0, blurY:0, strength:3, quality:2}, ease:Quad.easeOut});
            TweenMax.to(p, 0, {blurFilter:{blurX:10, blurY:10, quality:2}});        }
        
        private function fusionPlanet(a:Planet,b:Planet):void{
            if(!a.blackhole && !b.blackhole){
                var distance:Number = distance(a,b);
            
                a.x += (b.x-a.x)*(b.m/(a.m+b.m));
                a.y += (b.y-a.y)*(b.m/(a.m+b.m));
            
                a.pX += b.pX;
                a.pY += b.pY;
            
                space.removeChild(b);
            
                a.massUp(b.m);
            }
            else if(a.blackhole){
                a.massUp(b.m);
                space.removeChild(b);
            }
            else{
                b.massUp(a.m);
                space.removeChild(a);
            }


        }

        
        private function mouseDown(e:MouseEvent):void{
            mouseSx = mouseX;
            mouseSy = mouseY;
            mouseDx = mouseX - mouseSx;
            mouseDy = mouseY - mouseSy
            lineSpace.graphics.moveTo(mouseSx,mouseSy);
            mouseDownBool = true;
        }
        private function mouseMove(e:MouseEvent):void{
            if(mouseDownBool){
                lineSpace.graphics.clear();
                lineSpace.graphics.lineStyle(2,0x880000);
                lineSpace.graphics.moveTo(mouseSx,mouseSy);
                lineSpace.graphics.lineTo(mouseX,mouseY);
                mouseDx = mouseX - mouseSx;
                mouseDy = mouseY - mouseSy
            }
        }
        private function mouseUp(e:MouseEvent):void{
            this.createPlanet(mouseSx,mouseSy,1,mouseDx/30,mouseDy/30,false);
            lineSpace.graphics.clear();
            mouseDownBool = false;
        }
        private function keyUp(e:KeyboardEvent):void{
            if(e.keyCode == Keyboard.ENTER) enterBool = false;
            else if(e.keyCode == Keyboard.SPACE) spaceBool = false;
        }
        private function keyDown(e:KeyboardEvent):void{
            if(e.keyCode == Keyboard.ENTER) enterBool = true;
            else if(e.keyCode == Keyboard.SPACE) {
                spaceBool = true;
                createPlanet(mouseX,mouseY,300,0,0,true);
            }
        }

        
        private function distance(a:Planet,b:Planet):Number{
            return Math.sqrt((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y));
        }


    }

}

import flash.display.Sprite;

internal class Planet extends Sprite {
    public var m:Number;
    public var pX:Number;
    public var pY:Number;
    public var r:Number;
    public var blackhole:Boolean;
    
    public function Planet(im:Number, ipX:Number, ipY:Number, iblackhole:Boolean){
        m=im;
        pX=ipX;
        pY=ipY;
        blackhole = iblackhole;
        if(!blackhole){
            r=Math.pow(im,1/3);
            graphics.beginFill(0xffffff);
            graphics.drawCircle(0,0,r);
        }
        else {
            r = 0;
        }

    }
    
    public function massUp(im:Number):void{
        m+=im;
        if(!blackhole){
            r=Math.pow(m,1/3);
            graphics.beginFill(0xffffff);
            graphics.drawCircle(0,0,r);
       }
    }
}



////////////////////////////////
////////////////////////////////
////////////////////////////////


/*
package
{
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.Sprite;
  
    public class Main extends Sprite
    {     
        private const NUM_PARTICLES : int = 1;
        private const SPEED : Number = 1;
        private const MAX_POWER : Number = 100;        
        private var _canvas : BitmapData;  
        private var _pixels : Vector.<Object>;
        private var _alphaTransform : ColorTransform;
        private var _blurFilter : BlurFilter;
        private var _zeroPoint : Point;

        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;           
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
            addChild( new Bitmap( _canvas ) );       
            _pixels = new Vector.<Object>( NUM_PARTICLES, true );
            
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                var pixel : Object = {};
                pixel.x = Math.random() * stage.stageWidth;
                pixel.y = Math.random() * stage.stageHeight;
                pixel.dx = 0;
                pixel.dy = 0;
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;
                pixel.color = 0xFFFFFF;
                _pixels[i] = pixel;
            }
            
            _alphaTransform = new ColorTransform( 1, 1, 1, .9 );
            _blurFilter = new BlurFilter;
            _zeroPoint = new Point;
            
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            stage.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown );
        }
        
        private function onEnterFrame( e : Event ) : void
        {
            _canvas.lock();
            _canvas.applyFilter( _canvas, _canvas.rect, _zeroPoint, _blurFilter );
            _canvas.colorTransform( _canvas.rect, _alphaTransform );
            
            var pixel : Object;
            var angle : Number;
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                pixel = _pixels[i];
                
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;
                
                angle = Math.atan2( pixel.y - mouseY, pixel.x - mouseX );
                pixel.dx -= SPEED * Math.cos( angle );
                pixel.dy -= SPEED * Math.sin( angle );
                
                pixel.x += pixel.dx;
                pixel.y += pixel.dy;
                
                pixel.dx *= .95;
                pixel.dy *= .95;
                
                drawLine( pixel.lastX, pixel.lastY, pixel.x, pixel.y, pixel.color );
            }
            
            //canvas.applyFilter( canvas, canvas.rect, new Point, blurFilter );
            
            _canvas.unlock();
        }
        
        private function onMouseDown( e : MouseEvent ) : void
        {
            var pixel : Object;
            var randAngle : Number;
            var randPower : Number;
            
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                pixel = _pixels[i];
                randAngle = Math.random() * ( Math.PI << 1 );
                randPower = Math.random() * MAX_POWER - ( MAX_POWER >> 1 );
                pixel.dx = randPower * Math.cos( randAngle );
                pixel.dy = randPower * Math.sin( randAngle );
            }
        }
        
        private function drawLine( startX : Number, startY : Number, endX : Number, endY : Number, color : Number ) : void
        {
            var dx : Number = endX - startX;
            var dy : Number = endY - startY;
            var a : Number;
            var b : Number;
            var tmp : Number;
            var len : Number;
            var i : int;
            
            if( getAbs( dx ) > getAbs( dy ) )
            {
                a = dy / dx;
                b = startY;
                
                if( startX > endX )
                {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                    b = endY;
                }
                
                len = endX - startX;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i + startX, i * a + b, color );
                }
            }
            else
            {
                a = dx / dy;
                b = startX;
                
                if( startY > endY )
                {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                    b = endX;
                }
                
                len = endY - startY;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i * a + b, i + startY, color );
                }
            }
        }
        
        private function getAbs( x : Number ) : Number
        {
            return x < 0 ? -x : x;
        }
    }
}
*/

