/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1WdL
 */

// forked from flashmafia's MidPoint Angelo
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;

    [SWF(width = '465', height = '465', backgroundColor = '0x0', frameRate = '32')]


    public class MidPointAngelo extends Sprite
    {
        private const SIZE_X    :int     =  465;
        private const SIZE_Y    :int     =  465;
        private const NUM_P     :int     =  161800;   //  66666;
        private const E_ANGLE   :Number  =  0.618; //Golden Ratio seems to equal better performance. Not sure why, but it does ;)      // 0.191986217719; 
        private var _angf       :Number;
        private var _rect       :Rectangle;
        private var _p          :P;
        private var _blur       :BlurFilter;
        private var _dstp       :Point;
        private var _offscr     :BitmapData;
        private var _bitmapData :BitmapData;


        public function MidPointAngelo() 
        {
            //stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.fullScreenSourceRect = new Rectangle(0, 0, SIZE_X, SIZE_Y);
            stage.quality = StageQuality.BEST;
            //ENTRY POINT:
            
            _blur = new BlurFilter( 6,6,3 );     // 6,6,BitmapFilterQuality.HIGH );       // 8.5, 8.5, BitmapFilterQuality.HIGH);
            _dstp = new Point();

            var a : Number = 0; 
            var p : P = _p = new P();
            var n : uint = NUM_P; 
            while (--n != 0) 
            {
                a = a + Math.PI * 2 / NUM_P;
                p.ex = (SIZE_X >> 1) + ((SIZE_X >> 1) + (SIZE_X >> 2) * Math.random()) * Math.cos(a);
                p.ey = (SIZE_Y >> 1) + ((SIZE_Y >> 1) + (SIZE_Y >> 2) * Math.random()) * Math.sin(a);
                p.x = p.ex;
                p.y = p.ey;

                p = p.next = new P();
            }

            addChild(new Bitmap(_bitmapData = new BitmapData(SIZE_X, SIZE_Y, false, 0x0)));
            _offscr = _bitmapData.clone();
            _rect = _bitmapData.rect;

            _angf = 0.0;

            addEventListener(Event.ENTER_FRAME, step);
        }

        private function step(e : Event) : void {
            var pos : uint;
            var dx : Number;
            var dy : Number;

            _angf += (8.0 - _angf) * 0.00044;
            var ecos : Number = Math.cos(_angf * E_ANGLE);
            var esin : Number = Math.sin(_angf * E_ANGLE);

            var sx : int = SIZE_X;
            var cx : int = sx >> 1;
            var cy : int = SIZE_Y >> 1;
            // var seed : uint = 22;

            _offscr.applyFilter(_bitmapData, _rect, _dstp, _blur);

            var buffer : Vector.<uint> = _offscr.getVector(_rect);
            var buflen : uint = buffer.length;

            var p : P = _p;
            do {
                dx = p.ex - cx;
                dy = p.ey - cy;
                p.ex = cx + ecos * dx - esin * dy;
                p.ey = cy + ecos * dy + esin * dx;
                p.x = p.x + (p.ex - p.x) * 0.09;
                p.y = p.y + (p.ey - p.y) * 0.01;

                pos = p.y * sx + p.x;

                if (pos < buflen) {
                    var c : uint = buffer[pos];

                    var g : uint = ((c >> 8) & 0xFF) + 4;
                    var b : uint = (c & 0xFF) + 5;

                    g = (g > 0xFF) ? 0xFF : g;
                    b = (b > 0xFF) ? 0xFF : b;

                    buffer[pos] = 0 | (g << 8) | b;

                    // buffer[pos] = (seed = seed * 16807 % 2147483647);
                }

                p = p.next;
            } while (p != null);

            _bitmapData.setVector(_rect, buffer);
        }
    }
}




internal final class P 
{
    public var x : int = 0;
    public var y : int = 0;
    public var ex : int = 0;
    public var ey : int = 0;
    public var c : uint = 0x000000;
    public var next : P;
}
