/**
 * Copyright hikipuro ( http://wonderfl.net/user/hikipuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1VU1
 */

package {
    /**
     * 元ネタ
     * http://as3.betaruce.com/tut/fire/fire_f8.html
     *
     * トラのイラストは、「似顔絵、イラスト、キャラクター、フリー素材などの紹介ブログ」 さんからお借りしました。
     * http://yaplog.jp/rochirico/
     *
     * FlashDevelop 形式のソース
     * http://hikipuro.is-a-geek.org/flash/game/sample/s083.php
     */
    
    import flash.display.DisplayObjectContainer;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;

    [ SWF( width = "320" , height = "240" , backgroundColor = "0xFFFFFF" , frameRate = "30" ) ]
    public class FlashTest extends Sprite
    {
        /**
         * トラの画像データ (base64 エンコード)
         */
        private const data:String = "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";
        
		
        /**
         * トラの画像 (表示用のオブジェクト)
         */
        private var tigerBitmap:DisplayObjectContainer;
        
        /**
         * グラデーションの画像
         * （炎のもとになる）
         */
        private var gradientSprite:Sprite;
        
        /**
         * パーリンノイズを入れる
         */
        private var noise:BitmapData;
        
        /**
         * 炎の画像を入れる
         */
        private var fire:BitmapData;
        
        /**
         * パーリンノイズのスクロール量を調整する配列
         */
        private var scrollAmountArray:Array;
        
        /**
         * 変位マップフィルター
         */
        private var displacementMapFilter:DisplacementMapFilter;
        
        /**
         * コンストラクタ
         */
        public function FlashTest() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 初期化メソッド
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
	    // entry point
            
            // トラの画像を一番後ろに表示
            tigerBitmap = Base64ImageLoader.load(data);
            if (tigerBitmap != null)
                addChild(tigerBitmap);
                
            
            // グラデーションの画像を準備
            gradientSprite = new Sprite();
            
            // グラデーションのかかった四角形を描く
            var colors:Array = [0x000000, 0xff8000];
            var alphas:Array = [0.0, 1.0];
            var ratios:Array = [100, 255];
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(100, 100, Math.PI / 2, 0, 0);
            
            var g:Graphics = gradientSprite.graphics;
            
            g.lineStyle();
            g.beginGradientFill(GradientType.LINEAR, 
                                colors,
                                alphas,
                                ratios,
                                matrix);
            g.drawRect(0, 0, 100, 100);
            g.endFill();
            
            // パーリンノイズと炎の画像用のビットマップデータを初期化
            noise = new BitmapData(100, 100);
            fire = new BitmapData(100, 100);
            fire.floodFill(0, 0, 0x00000000);
            
            // 炎の画像を画面に表示するように登録する
            var fireBitmap:Bitmap;
            fireBitmap = new Bitmap(fire);
            fireBitmap.width = 320;
            fireBitmap.height = 240;
            addChild(fireBitmap);
            
            // スクロール量を調整する配列の初期化
            scrollAmountArray = new Array();
            scrollAmountArray.push(new Point(0, 0));
            
            // 変位マップフィルターの初期化
            displacementMapFilter = 
                new DisplacementMapFilter(noise, 
                                          new Point(0, 0), 
                                          1, 2, 5, 30, 
                                          DisplacementMapFilterMode.IGNORE);
            
            // フレーム開始イベントの登録
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        /**
         * フレーム開始イベント
         * @param    e
         */
        private function onEnterFrame(e:Event):void 
        {
            // パーリンノイズのスクロール量を調整
            var vy:Number = 10;
            var vx:Number = 0;
            scrollAmountArray[0].x += vx;
            scrollAmountArray[0].y += vy;
            
            // パーリンノイズを発生させる
            noise.perlinNoise(20, 150, 
                              2, 2, 
                              true, false, 
                              7, false, 
                              scrollAmountArray);
            
            // グラデーションの画像を炎のビットマップデータにいったんそのまま転送
            fire.draw(gradientSprite, new Matrix(1, 0, 0, 1, 0, 0));
            
            // 炎の画像に変位マップフィルターを適用
            fire.applyFilter(fire, 
                             fire.rect, 
                             new Point(0, 0), 
                             displacementMapFilter);
            
        }
    }
}

/**
 * Base64化された画像データを表示可能な形式に変換するクラス
 * 
 * 使い方 :
 * var data:String = "Base64化された画像データ";
 * var display:DisplayObjectContainer = Base64ImageLoader.load(data);
 * if (display != null)
 *     addChild(display);
 */
class Base64ImageLoader
{
    import flash.display.DisplayObjectContainer;
    import flash.display.Loader;
    import flash.utils.ByteArray;
    import mx.utils.Base64Decoder;

    static public function load(data:String):DisplayObjectContainer
    {
        var byteArray:ByteArray;
        var base64Decoder:Base64Decoder;
        var loader:Loader;
        
        base64Decoder = new Base64Decoder();
        base64Decoder.decode(data);
        
        try {
            byteArray = base64Decoder.toByteArray();
            byteArray.position = 0;
        } catch (e:Error) {
            return null;
        }
        
        loader = new Loader();
        loader.loadBytes(byteArray);
        
        return loader;
    }
}