/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1V02
 */

//
//	東風谷早苗が最初に出現した時の弾幕風処理。
//	動きは多分あってると思う＾ｑ＾
//
//	http://wonderfl.net/code/0985a71ecf289c27e0bec30c5a2ee9387cac6c2e
//	の角度計算部分をちょっと変えるとこうなります
//
//	表示レイヤーは考慮していないです。余計なパラメータもあるかと思いますｗ
//	クリックすると新たに作成します
//
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(backgroundColor = "0x000000", frameRate = "60")]

	/**
	 * 
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private var	patternList:Array = new Array();
		
		private var moveBullet:Array = new Array();
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			MouseDown(null);
			
			addEventListener(Event.ENTER_FRAME, EnterFrame );
			stage.addEventListener(MouseEvent.MOUSE_DOWN, MouseDown);
		}
		
		private function EnterFrame(event:Event):void 
		{
			var i:int = 0;
			

			for ( i = 0; i < patternList.length; i++ )
			{
				var bullet:Bullet = patternList[i].Run();
				if ( bullet != null )
				{
					addChild( bullet );
				}
			}
			for ( i = patternList.length - 1; i >= 0; i-- )
			{
				if ( patternList[i].isEnd() )
				{
					//	待機リストから移動リストへ
					for ( var j:int = 0; j < patternList[i].waitBullet.length; j++ )
					{
						patternList[i].waitBullet[j].StartSlide();
						moveBullet.push( patternList[i].waitBullet[j] );						
					}
					patternList.splice( i, 1 );						
				}
			}
					
			//	弾移動
			if ( moveBullet.length > 0 )
			{
				for ( i = moveBullet.length - 1; i >= 0; i-- )
				{
					//	スライド中な場合
					if ( moveBullet[i].slideFlag )
					{
						moveBullet[i]._xx += Math.cos( moveBullet[i].slideAngle * Math.PI / 180 ) * moveBullet[i].slideSpeed;
						moveBullet[i]._xy += Math.sin( moveBullet[i].slideAngle * Math.PI / 180 ) * moveBullet[i].slideSpeed;
						moveBullet[i].x = moveBullet[i]._xx;
						moveBullet[i].y = moveBullet[i]._xy;
					
						if ( moveBullet[i].slideSpeed > 0 )
						{
							moveBullet[i].slideSpeed -= moveBullet[i].slideSpeedMax / 50;
							if ( moveBullet[i].slideSpeed < 0 )	moveBullet[i].slideFlag = false;
						}
						
					}else
					{	
						moveBullet[i]._xx += Math.cos( moveBullet[i].moveAngle * Math.PI / 180 ) * 1;
						moveBullet[i]._xy += Math.sin( moveBullet[i].moveAngle * Math.PI / 180 ) * 1;
						moveBullet[i].x = moveBullet[i]._xx;
						moveBullet[i].y = moveBullet[i]._xy;
						
						if ( moveBullet[i].x < -50 || moveBullet[i].x > stage.stageWidth + 50 || moveBullet[i].y < -50 || moveBullet[i].y > stage.stageHeight + 50 )
						{
							removeChild( moveBullet[i] );
							moveBullet.splice( i, 1 );
						}
					}
				}
			}
		}
		
		private function MouseDown(event:MouseEvent):void
		{
			//	小さい☆
			//patternList.push( new Pattern(stage.stageWidth / 2, stage.stageHeight / 2, false, 50, 0xFF5555, (270 + 72 * 0), 3 ) );
			//patternList.push( new Pattern(stage.stageWidth / 2, stage.stageHeight / 2, false, 50, 0xFF5555, (270 + 72 * 1), 3 ) );
			//patternList.push( new Pattern(stage.stageWidth / 2, stage.stageHeight / 2, false, 50, 0xFF5555, (270 + 72 * 2), 3 ) );
			//patternList.push( new Pattern(stage.stageWidth / 2, stage.stageHeight / 2, false, 50, 0xFF5555, (270 + 72 * 3), 3 ) );
			//patternList.push( new Pattern(stage.stageWidth / 2, stage.stageHeight / 2, false, 50, 0xFF5555, (270 + 72 * 4), 3 ) );
			//	大きい☆
			patternList.push( new Pattern(stage.stageWidth/2, stage.stageHeight/2, false, 100, 0x5555FF, (270 + 72 * 0), 5 ) );
			patternList.push( new Pattern(stage.stageWidth/2, stage.stageHeight/2, false, 100, 0x5555FF, (270 + 72 * 1), 5 ) );
			patternList.push( new Pattern(stage.stageWidth/2, stage.stageHeight/2, false, 100, 0x5555FF, (270 + 72 * 2), 5 ) );
			patternList.push( new Pattern(stage.stageWidth/2, stage.stageHeight/2, false, 100, 0x5555FF, (270 + 72 * 3), 5 ) );
			patternList.push( new Pattern(stage.stageWidth/2, stage.stageHeight/2, false, 100, 0x5555FF, (270 + 72 * 4), 5 ) );
		}
		
	}
	
}
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
import flash.display.Sprite;
import flash.geom.Point;

//-----------------------------
//	弾幕パターンクラス
class Pattern {
	
	private var reverse:Boolean = false;		//	反転フラグ
	private var starSize:Number = 150;			//	☆サイズ
	private var bulletColor:uint = 0x000000;	//	発生させる弾の色
	
	private var slideAngle:Number = 0;			//	弾スライド時に使用
	private var slideSpeed:Number = 0;			//	弾スライド時に使用
	
	private var end:Boolean = false;
	private var count:int = 0;
	private var defX:int = 0;
	private var defY:int = 0;
			
	private var target:Array = new Array();
	
	private static const PATH_OBJ_NUM:int = 20;		//	１辺に出す弾の数
	private static const TARGET_NUM:int = 5;
	private static const TARGET_ANGLE:Array = [ 270 + 72 * 3, 270 + 72 * 1, 270 + 72 * 4, 270 + 72 * 2, 270 ];	//	パスの目標地点の角度
	private static const TARGET_ANGLE2:Array = [ 270 + 72 * 2, 270 + 72 * 4, 270 + 72 * 1, 270 + 72 * 3, 270 ];	//	パスの目標地点の角度

	public	var waitBullet:Array = new Array();		//	保持用バッファ
	
	public function Pattern(
		_gx:int = 0, _gy:int = 0,
		_rev:Boolean = false,
		_starSize:Number = 80,
		_bulletColor:uint = 0x000000,
		_slideAngle:Number = 0,
		_slideSpeed:Number = 0 
	) {
		count = 0;
		defX = _gx;
		defY = _gy;
		
		reverse = _rev;
		starSize = _starSize;
		bulletColor = _bulletColor;
		slideAngle = _slideAngle;
		slideSpeed = _slideSpeed;
		
		for ( var i:int = 0; i < 5; i++ )
		{
			var angle:Number = TARGET_ANGLE[i];
			if ( reverse ) angle = TARGET_ANGLE2[i] + 180;	//	反転
			else 		   angle = TARGET_ANGLE[i];

			target[i] = new Point( Math.cos( angle * Math.PI / 180 ) * starSize, Math.sin( angle * Math.PI / 180 ) * starSize );
		}
	}
	/**
	 * 弾発生処理
	 * @return
	 */
	public function Run() : Bullet {
		
		var bullet:Bullet = new Bullet(bulletColor,slideAngle,slideSpeed);
			
		var targetNo:int = int(count / PATH_OBJ_NUM);
		var targetRate:int = int(count % PATH_OBJ_NUM);
		var p:Point;

		//	弾の座標を出す
		p = Point.interpolate( target[targetNo], target[(targetNo+(TARGET_NUM-1))%TARGET_NUM], targetRate / PATH_OBJ_NUM );		
		bullet.x = p.x + defX;
		bullet.y = p.y + defY;
        bullet._xx = p.x + defX;
        bullet._xy = p.y + defY;

		//    弾の移動角度を出す(グレイソーマタージ）
        //if( !reverse )	bullet.moveAngle = -count / PATH_OBJ_NUM / TARGET_NUM * 720 + 135;
		//else			bullet.moveAngle = count / PATH_OBJ_NUM / TARGET_NUM * 720 - 135;

		bullet.moveAngle = ( -int(count / PATH_OBJ_NUM) / TARGET_NUM * 720 + 108) + ((count % PATH_OBJ_NUM) * 180 / PATH_OBJ_NUM);	//	Target始点角度 + 180 * rate	グレイソーに入る前の奴

		
		waitBullet.push( bullet );
		
		count++;
		if ( count == TARGET_NUM * PATH_OBJ_NUM )	end = true;
		
		return	bullet;
	}

	public	function isEnd() : Boolean {	return	end;	}
}

//-----------------------------
//	弾クラス
class Bullet extends Sprite {
	
	public	var slideFlag:Boolean = false;	//	スライド中フラグ
	
	public	var slideAngle:Number = 0;
	public	var slideSpeed:Number = 0;
	public	var slideSpeedMax:Number = 0;
	public	var moveAngle:Number = 0;
	
	public	var _xx:Number = 0;
	public	var _xy:Number = 0;
	
	public function Bullet(color:uint,_slideAngle:Number = 0,_slideSpeed:Number = 50) {
		super();
		
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, 5);
		graphics.endFill();
		
		graphics.beginFill(0xFFFFFF, 0.5);
		graphics.drawCircle(0, 0, 3);
		graphics.endFill();
		
		slideAngle = _slideAngle;
		slideSpeed = _slideSpeed;
		slideSpeedMax = _slideSpeed;
		
		slideFlag = false;
	}
	
	public	function StartSlide():void 
	{
		slideFlag = true;
	}
	
}