/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1UOg
 */

// forked from termat's Circles
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(width = "480", height = "480", backgroundColor = "0xffffff", fps = "60")] 
	
	import flash.display.Graphics
	import flash.display.Shape;
	
	public class Practice75 extends Sprite{
		private var list:Vector.<Circle>; // reference storage
		private var id:int = 0;
		private var shape:Shape // where we draw
		private var g:Graphics // graphics reference
		private var i:uint // loop
		
		public function Practice75() 
		{
			list = new Vector.<Circle>();
			shape = new Shape();
			
			stage.addChild(shape);
			g = shape.graphics;
			
			// the first circle
			var c:Circle = new Circle(mouseX, mouseY, 1, getColor(id, 1.0));
			list.push(c);
			
			// listener
			stage.addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void {
			var c:Circle = new Circle(mouseX, mouseY, 1, getColor(id, 1.0));
			i = list.length-1
			c.prev = list[i]
			list.push(c);
			//
			id = (++id) % 360;
			g.clear();
			++i
			c.draw(g) // last circle
			while ((c = c.prev) != null)
			{
				--i
				c.draw(g) // prev circles
				if (c.radius >= 480)
				{
					list.splice(i, 1) // remove reference from vector
					list[i+1].prev = null // remove reference from next circle (prev reference)
				}
			}
		}
		
		private function getColor(i:int, saturation:Number):uint {
			var h:Number = i / 60;
			var ii:Number = Math.floor(h);
			var ff:Number = h - ii;
			var p1:Number = (1.0 - saturation);
			var p2:Number = (1.0 - saturation * ff);
			var p3:Number = (1.0 - saturation * (1.0 - ff));
			var rv:Number, gv:Number, bv:Number;
			switch(ii) {
			case 0:
				rv = 1.0, gv = p3, bv = p1;
				break;
			case 1:
				rv = p2, gv = 1.0, bv = p1;
				break;
			case 2:
				rv = p1, gv = 1.0, bv = p3;
				break;
			case 3:
				rv = p1, gv = p2, bv = 1.0;
				break;
			case 4:
				rv = p3, gv = p1, bv = 1.0;
				break;
			default:
				rv = 1.0, gv = p1, bv = p2;
			}
			var color:uint = (Math.max(0, Math.min(255, rv * 255)) << 16) + (Math.max(0, Math.min(255, gv * 255)) << 8) + Math.max(0, Math.min(255, bv * 255));
			return color;
		}
	}
}

import flash.display.MovieClip;
import flash.display.Graphics;
class Circle
{
	public var x:Number;
	public var y:Number;
	private var width:Number = 2;
	public var radius:Number;
	public var color:uint;
	public var alpha:Number = 1.0;
	public var prev:Circle
	
	public function Circle(x:Number = 0,y:Number = 0, radius:Number = 1, color:uint = 0):void
	{
		this.x = x
		this.y = y
		this.radius = radius
		this.color = color
	}
	
	public function draw(g:Graphics):void {
		g.lineStyle(width, color);
		g.drawCircle(x, y, radius);
		radius += 4;
		alpha *= 0.9;
	}
}