/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1U72
 */

/*
 * ★NewNumericStepper
 * 
 * コードだけで生成するNumericStepper的なもの。
 * 
 * widthでサイズを変えると、stepperは同じサイズのままテキストフィールド
 * だけ拡大縮小するという性質をどう実装するかで迷った。
 * heightをかえると不格好になる。けど、これを実装するといろいろ
 * めんどうなわりに、普通使わないと思うので、このまま。
 * 
 * addEventListenerについてはCHANGEのみ。
 * addEventListenerの実装がかなり面倒ということに
 * 制作の終盤になってから気がついた（遅すぎ）。
 * もっと上手い方法があるんだろうなと思いながらだったけど、
 * 実際に自分が使うぶんにはほとんど問題にならないような気がしたので
 * 問題にあたったら、機能追加する方向で。
 * 
 * 
*/
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.geom.Matrix;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.display.SimpleButton;
	import flash.display.StageScaleMode;
				
	[SWF(backgroundColor="0xFFFFFF")]
	public class Main extends Sprite {
		private var newNSx:NewNumericStepper = new NewNumericStepper();
		private var newNSy:NewNumericStepper = new NewNumericStepper();
		private var nsx:Sprite = newNSx.make({value:200,minimum:100,maximum:460,stepSize:10});
		private var ball:Sprite = Create.newSprite([200, 200], [ ["buttonMode", true]], [["beginFill", [0x666666, 1]], ["drawCircle", [0, 0, 30]]]);
		
		//この関数がまず実行される。
		public function Main() {
			var nsy:Sprite = newNSy.make({value:200,minimum:100,maximum:460,stepSize:20});
			addChild(nsx);
			addChild(ball);
			nsx.x= 200;
			nsy.y= 200;
			addChild(nsy);
			newNSx.addEventListener(Event.CHANGE,fn);
			newNSy.addEventListener(Event.CHANGE,fn);
			
			//表示見本用
			addChild(new NewNumericStepper().make({enabled:false},[10,10]));
			addChild(new NewNumericStepper().make({width:220},[10,440]));
			
			function fn(e:Event):void{
				ball.x = newNSx.value;
				ball.y = newNSy.value;
			}
		}
	}
}


import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.SimpleButton;
import flash.events.MouseEvent;
import flash.events.Event;
import flash.events.KeyboardEvent;

class NewNumericStepper{
	private var _enabled:Boolean = true;
	public var maximum:Number = 10;
	public var minimum:Number = 0;
	public var stepSize:Number = 1;
	private var _value:Number = 1;
	private var _textField:TextField;
	private var _width:Number = 80;
	private var _height:Number = 22;
	public var down:SimpleButton;
	public var up:SimpleButton;
	private var cover:Sprite;
	
	public function make(obj:Object = null,array:Array = null):Sprite{
		if(obj){
			if(obj.enabled != undefined){
				_enabled = obj.enabled;
			}
			if(obj.maximum || obj.maximum == 0){
				maximum = obj.maximum;
			}
			if(obj.minimum || obj.minimum == 0){
				minimum = obj.minimum;
			}
			if(obj.stepSize || obj.stepSize == 0){
				stepSize = obj.stepSize;
			}
			if(obj.value || obj.value == 0){
				value = obj.value;
			}
			if(obj.width || obj.width == 0){
				_width = obj.width;
			}
			if(obj.height || obj.height == 0){
				_height = obj.height;
			}
		}
		var sp:Sprite = Create.newSprite(array);
		Create.defaultTextFormat = new TextFormat("_sans");
		_textField = Create.newTextField([0,0,_width-20,_height-1,String(value)],[["background",true],["border",true],["borderColor",0xCCCCCC]]);
		_textField.type = "input";
		_textField.addEventListener(Event.CHANGE,evCHANGE);
		_textField.addEventListener(KeyboardEvent.KEY_DOWN,KEY_DOWN);
		
		sp.addChild(_textField);
		down = newSimpleButton2([0,_height/2-1,20,_height/2+1],true);
		up = newSimpleButton2([0,0,20,_height/2]);
		up.x = down.x = _width-20;
		up.addEventListener(MouseEvent.MOUSE_DOWN,MOUSE_UP);
		down.addEventListener(MouseEvent.MOUSE_DOWN,MOUSE_DOWN);
		up.tabEnabled = false;
		down.tabEnabled = false;
		sp.addChild(up);
		sp.addChild(down);
		cover = Create.newSprite([0,0],null,[["beginFill",[0xFFFFFF,0.6]],["moveTo",[0,0]],["lineTo",[_width-4,0]],["curveTo",[_width,0,_width,4]],["lineTo",[_width,_height-4]],["curveTo",[_width,_height,_width-4,_height]],["lineTo",[0,_height]]]);
		cover.visible = !enabled;
		sp.addChild(cover);
		return sp;
	}
	public function addEventListener(str:String,fn:Function):void{
		this[str] = fn;
	}
	private var change:Function = function(e:Event):void{};
	
	public function get enabled():Boolean{
		return _enabled;
	}
	public function set enabled(_is:Boolean):void{
		_enabled = _is;
		cover.visible = !_enabled;
	}
	public function get textField():TextField{
		return _textField;
	}
	public function set width(num:Number):void{
		_width = num;
		up.x = down.x = _width-20;
		_textField.width = _width-20;
	}
	public function get width():Number{
		return _width;
	}
	public function set value(num:Number):void{
		num = Math.max(Math.min(num,maximum),minimum);
		_value = num;
	}
	public function get value():Number{
		return _value;
	}
	private function KEY_DOWN(e:KeyboardEvent):void{
		if(e.keyCode == 40){
			MOUSE_DOWN();
		}else if(e.keyCode == 38){
			MOUSE_UP();
		}
	}
	private function evCHANGE(e:Event):void{
		value = Number(e.currentTarget.text);
		change(e);
	}
	private function MOUSE_UP(e:MouseEvent = null):void{
		if(value >= maximum){
			return;
		}
		value += stepSize;
		_textField.text = String(value);
		change(e);
	}
	private function MOUSE_DOWN(e:MouseEvent = null):void{
		if(value <= minimum){
			return;
		}
		value -= stepSize;
		_textField.text = String(value);
		change(e);
	}
	private static function newSimpleButton2(x_y_w_h_txt:Array = null,isDown:Boolean = false):SimpleButton{
		var upState:Sprite;
		var overState:Sprite;
		var downState:Sprite;
		if(isDown){
			upState = Create.newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xCCCCCC,1]],["moveTo",[0,0]],["lineTo",[x_y_w_h_txt[2],0]],["lineTo",[x_y_w_h_txt[2],x_y_w_h_txt[3]-4]],["curveTo",[x_y_w_h_txt[2],x_y_w_h_txt[3],x_y_w_h_txt[2]-4,x_y_w_h_txt[3]]],["lineTo",[0,x_y_w_h_txt[3]]]]);
			upState.addChild(Create.newShape([0,0],null,[["beginFill",[0xE5E5E5,1]],["moveTo",[1,1]],["lineTo",[x_y_w_h_txt[2]-1,1]],["lineTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-5]],["curveTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-1,x_y_w_h_txt[2]-5,x_y_w_h_txt[3]-1]],["lineTo",[1,x_y_w_h_txt[3]-1]]]));
			overState = Create.newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xBBBBBB,1]],["moveTo",[0,0]],["lineTo",[x_y_w_h_txt[2],0]],["lineTo",[x_y_w_h_txt[2],x_y_w_h_txt[3]-4]],["curveTo",[x_y_w_h_txt[2],x_y_w_h_txt[3],x_y_w_h_txt[2]-4,x_y_w_h_txt[3]]],["lineTo",[0,x_y_w_h_txt[3]]]]);
			overState.addChild(Create.newShape([0,0],null,[["beginFill",[0xEEEEEE,1]],["moveTo",[1,1]],["lineTo",[x_y_w_h_txt[2]-1,1]],["lineTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-5]],["curveTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-1,x_y_w_h_txt[2]-5,x_y_w_h_txt[3]-1]],["lineTo",[1,x_y_w_h_txt[3]-1]]]));
			downState = Create.newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xAAAAAA,1]],["moveTo",[0,0]],["lineTo",[x_y_w_h_txt[2],0]],["lineTo",[x_y_w_h_txt[2],x_y_w_h_txt[3]-4]],["curveTo",[x_y_w_h_txt[2],x_y_w_h_txt[3],x_y_w_h_txt[2]-4,x_y_w_h_txt[3]]],["lineTo",[0,x_y_w_h_txt[3]]]]);
			downState.addChild(Create.newShape([0,0],null,[["beginFill",[0xDDDDDD,1]],["moveTo",[1,1]],["lineTo",[x_y_w_h_txt[2]-1,1]],["lineTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-5]],["curveTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-1,x_y_w_h_txt[2]-5,x_y_w_h_txt[3]-1]],["lineTo",[1,x_y_w_h_txt[3]-1]]]));
			upState.addChild(Create.newShape([0,1],null,[["beginFill",[0,1]],["moveTo",[10,7]],["lineTo",[6,3]],["lineTo",[14,3]]]));
			overState.addChild(Create.newShape([0,1],null,[["beginFill",[0,1]],["moveTo",[10,7]],["lineTo",[6,3]],["lineTo",[14,3]]]));
			downState.addChild(Create.newShape([0,2],null,[["beginFill",[0x666666,1]],["moveTo",[10,7]],["lineTo",[6,3]],["lineTo",[14,3]]]));
		}else{
			upState = Create.newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xCCCCCC,1]],["moveTo",[0,0]],["lineTo",[x_y_w_h_txt[2]-4,0]],["curveTo",[x_y_w_h_txt[2],0,x_y_w_h_txt[2],4]],["lineTo",[x_y_w_h_txt[2],x_y_w_h_txt[3]]],["lineTo",[0,x_y_w_h_txt[3]]]]);
			upState.addChild(Create.newShape([0,0],null,[["beginFill",[0xE5E5E5,1]],["moveTo",[1,1]],["lineTo",[x_y_w_h_txt[2]-5,1]],["curveTo",[x_y_w_h_txt[2]-1,1,x_y_w_h_txt[2]-1,5]],["lineTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-1]],["lineTo",[1,x_y_w_h_txt[3]-1]]]));
			overState = Create.newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xBBBBBB,1]],["moveTo",[0,0]],["lineTo",[x_y_w_h_txt[2]-4,0]],["curveTo",[x_y_w_h_txt[2],0,x_y_w_h_txt[2],4]],["lineTo",[x_y_w_h_txt[2],x_y_w_h_txt[3]]],["lineTo",[0,x_y_w_h_txt[3]]]]);
			overState.addChild(Create.newShape([0,0],null,[["beginFill",[0xEEEEEE,1]],["moveTo",[1,1]],["lineTo",[x_y_w_h_txt[2]-5,1]],["curveTo",[x_y_w_h_txt[2]-1,1,x_y_w_h_txt[2]-1,5]],["lineTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-1]],["lineTo",[1,x_y_w_h_txt[3]-1]]]));
			downState = Create.newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xAAAAAA,1]],["moveTo",[0,0]],["lineTo",[x_y_w_h_txt[2]-4,0]],["curveTo",[x_y_w_h_txt[2],0,x_y_w_h_txt[2],4]],["lineTo",[x_y_w_h_txt[2],x_y_w_h_txt[3]]],["lineTo",[0,x_y_w_h_txt[3]]]]);
			downState.addChild(Create.newShape([0,0],null,[["beginFill",[0xDDDDDD,1]],["moveTo",[1,1]],["lineTo",[x_y_w_h_txt[2]-5,1]],["curveTo",[x_y_w_h_txt[2]-1,1,x_y_w_h_txt[2]-1,5]],["lineTo",[x_y_w_h_txt[2]-1,x_y_w_h_txt[3]-1]],["lineTo",[1,x_y_w_h_txt[3]-1]]]));
			upState.addChild(Create.newShape([0,-1],null,[["beginFill",[0,1]],["moveTo",[10,4]],["lineTo",[6,8]],["lineTo",[14,8]]]));
			overState.addChild(Create.newShape([0,-1],null,[["beginFill",[0,1]],["moveTo",[10,4]],["lineTo",[6,8]],["lineTo",[14,8]]]));
			downState.addChild(Create.newShape([0,0],null,[["beginFill",[0x666666,1]],["moveTo",[10,4]],["lineTo",[6,8]],["lineTo",[14,8]]]));
		}
		
		var hitTestState:Shape = Create.newShape([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0,1]],["drawRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3]]]]);
		var sb:SimpleButton = new SimpleButton(upState,overState,downState,hitTestState);
		return sb;
	}
}

class Create{
	public static var defaultTextFormat:TextFormat = new TextFormat();
	
	public static function newSimpleButton(x_y_w_h_txt:Array = null,property:Array=null,graphics:Array=null):SimpleButton{
		var upState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xCCCCCC,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
		upState.addChild(newShape([2,2],null,[["beginFill",[0xE5E5E5,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
		var overState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xBBBBBB,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
		overState.addChild(newShape([2,2],null,[["beginFill",[0xEEEEEE,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
		var downState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xAAAAAA,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
		downState.addChild(newShape([2,2],null,[["beginFill",[0xDDDDDD,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
		var hitTestState:Shape = newShape([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
		if(x_y_w_h_txt[4]){
			upState.addChild(newTextField([0,2,x_y_w_h_txt[2],x_y_w_h_txt[3]-2],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
			overState.addChild(newTextField([0,2,x_y_w_h_txt[2],x_y_w_h_txt[3]-2],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
			downState.addChild(newTextField([0,3,x_y_w_h_txt[2],x_y_w_h_txt[3]-3],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
		}
		var sb:SimpleButton = new SimpleButton(upState,overState,downState,hitTestState);
		
		return sb;
	}
	
	public static function newShape(x_y_w_h_sh:Array = null,property:Array=null,graphics:Array=null):Shape{
		var i:int;
		var sh:Shape;
		if(x_y_w_h_sh && x_y_w_h_sh[4]){
			sh = x_y_w_h_sh[4];
		}else{
			sh = new Shape();
		}
		if(x_y_w_h_sh){
			if (x_y_w_h_sh[0]) { sh.x = x_y_w_h_sh[0] };
			if (x_y_w_h_sh[1]) { sh.y = x_y_w_h_sh[1] };
		}
		if(property){
			for (i = 0; i < property.length; i++) {
				if(property[i] && property[i].length > 1){
					sh[property[i][0]] = property[i][1];
				}
			}
		}
		if(graphics){
			for (i = 0; i < graphics.length; i++) {
				if(graphics[i] && graphics[i].length > 1){
					sh.graphics[graphics[i][0]].apply(null, graphics[i][1]);
				}
			}
			
		}
		if(x_y_w_h_sh){
			if (x_y_w_h_sh[2]) { sh.width = x_y_w_h_sh[2] };
			if (x_y_w_h_sh[3]) { sh.height = x_y_w_h_sh[3] };
		}
		return sh;
	}
	public static function newSprite(x_y_w_h_sp:Array = null,property:Array=null,graphics:Array=null,addChild:DisplayObject = null):Sprite{
		var i:int;
		var sp:Sprite;
		if(x_y_w_h_sp && x_y_w_h_sp[4]){
			sp = x_y_w_h_sp[4];
		}else{
			sp = new Sprite();
		}
		if(x_y_w_h_sp){
			if (x_y_w_h_sp[0]) { sp.x = x_y_w_h_sp[0] };
			if (x_y_w_h_sp[1]) { sp.y = x_y_w_h_sp[1] };
		}
		if(property){
			for (i = 0; i < property.length; i++) {
				if(property[i] && property[i].length > 1){
					sp[property[i][0]] = property[i][1];
				}
			}
		}
		if(graphics){
			for (i = 0; i < graphics.length; i++) {
				if(graphics[i] && graphics[i].length > 1){
					sp.graphics[graphics[i][0]].apply(null, graphics[i][1]);
				}
			}
			
		}
		if(addChild){
			sp.addChild(addChild);
		}
		if(x_y_w_h_sp){
			if (x_y_w_h_sp[2]) { sp.width = x_y_w_h_sp[2] };
			if (x_y_w_h_sp[3]) { sp.height = x_y_w_h_sp[3] };
		}
		return sp;
	}

	public static function newTextField(x_y_w_h_txt_color_alpha:Array = null,property:Array=null,method:Array=null):TextField{
		var i:int;
		var ta:TextField = new TextField();
		ta.defaultTextFormat = defaultTextFormat;
		if(x_y_w_h_txt_color_alpha){
			if (x_y_w_h_txt_color_alpha[0]) { ta.x = x_y_w_h_txt_color_alpha[0] };
			if (x_y_w_h_txt_color_alpha[1]) { ta.y = x_y_w_h_txt_color_alpha[1] };
			if (x_y_w_h_txt_color_alpha[2]) { ta.width = x_y_w_h_txt_color_alpha[2] };
			if (x_y_w_h_txt_color_alpha[3]) { ta.height = x_y_w_h_txt_color_alpha[3] };
			if (x_y_w_h_txt_color_alpha[4]) { ta.text = x_y_w_h_txt_color_alpha[4] };
			if (x_y_w_h_txt_color_alpha[5]) { ta.textColor = x_y_w_h_txt_color_alpha[5] };
			if (x_y_w_h_txt_color_alpha[6]) { ta.alpha = x_y_w_h_txt_color_alpha[6] };
		}
		if(property){
			for (i = 0; i < property.length; i++) {
				if(property[i] && property[i].length > 1){
					ta[property[i][0]] = property[i][1];
				}
			}
		}
		if(method){
			for (i = 0; i < method.length; i++) {
				if(method[i] && method[i].length > 1){
					ta[method[i][0]].apply(null, method[i][1]);
				}
			}
		}
		return ta;
	}
}
