/**
 * Copyright huixie ( http://wonderfl.net/user/huixie )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1TTU
 */

package {
 import flash.display.Shape;
 import flash.display.Sprite;
 import flash.text.TextField;
 import flash.events.MouseEvent;
 import flash.external.ExternalInterface;
 import flash.system.Security;

 public class FlashButtons extends Sprite
 {
  public var testButton1:MyButton;
  public var testText1:TextField;
  
  public var testText2:TextField;
  
  var showCnt:int=0;
    
  public function FlashButtons() {
   testText1 = new TextField();
   testText1.text = "StartRunJavaScript";
   testText1.x =50;
   testText1.y =50;
   addChild(testText1);
   
   testButton1 = new MyButton(64, 18, 8, "RunJavaScript", 12);
   testButton1.x = 50;
   testButton1.y = 100;
   testButton1.doubleClickEnabled = true;
   testButton1.addEventListener(
   MouseEvent.DOUBLE_CLICK,StopDoubleClickForTest);
   testButton1.addEventListener(MouseEvent.CLICK,clickEventForTest);   
   addChild(testButton1);
   
   testText2 = new TextField();
   testText2.text = "StartCallFlash1";
   testText2.x =150;
   testText2.y =50;
   addChild(testText2);
 
  // swfを読み込んだhtmlが置いてあるドメインのjs -> asアクセスを許可する
   Security.allowDomain(ExternalInterface.call("function() { return location.hostname }"));

   ExternalInterface.addCallback("flashTestCall",flCall);
  }
 
   private function clickEventForTest(event1:MouseEvent):void{
   showCnt += 1;
   var a1:String = new String();
   a1 = String(showCnt);
   testText1.text= "Click Count is " + a1;
   }
  
  private function StopDoubleClickForTest(event2:MouseEvent):void{
   testText1.text= "Stop! double click";
   testText1.text =  ExternalInterface.call("jsCall",showCnt);
  }
  
  private function flCall(pSt:String):void{
      testText2.text = "from flashCall" + pSt; 
  }
  
 }  //end of Class
}  //end of Package

import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.geom.Matrix;
import flash.filters.ColorMatrixFilter;
import flash.filters.GlowFilter;

class MyButton extends Sprite{
    private static const mono:ColorMatrixFilter = new ColorMatrixFilter([
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
        1 / 3, 1 / 3, 1 / 3, 0, 10,
            0,     0,     0, 1, 0
    ]);

    private var _textField:TextField = new TextField();
    private var _size:int;

    private var _hover:Boolean = false;
    public function get hover():Boolean{
        return _hover;
    }
    public function set hover(value:Boolean):void{
        if(_hover != value){
            _hover = value;
            filters = (_hover ? null : [mono]);
        }
    }

    public function MyButton(W:Number, H:Number, R:Number, label:String = "", size:int = 11){
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(W, H, Math.PI / 2);

        var bg:Sprite = new Sprite();

        bg.graphics.beginGradientFill("linear", [0x8c99a4, 0xc5d4e1, 0xBAD2E8], [1, 1, 1],
            [0, 120, 136], matrix);
        bg.graphics.drawRoundRect(0, 0, W, H, R, R);
        bg.graphics.endFill();

        bg.filters = [new GlowFilter(0xFFFFBE, .5, 10, 10, 2, 1, true)];
        addChild(bg);

        var line:Sprite = new Sprite();
        line.graphics.lineStyle(3, 0xBAD2E8);
        line.graphics.drawRoundRect(0, 0, W, H, R, R);
        addChild(line);

        filters = [mono];
        buttonMode = true;
        mouseChildren = false;

        if (label != ""){
            _size = size;
            _textField.selectable = false;
            _textField.autoSize = "left";
            _textField.htmlText = <font size={size} color="#4B4349">{label}</font>.toXMLString();
            _textField.x = (W - _textField.width) / 2;
            _textField.y = (H - _textField.height) / 2;
            addChild(_textField);
        }

        addEventListener("rollOver", buttonRollOver);
        addEventListener("rollOut", buttonRollOut);
        addEventListener("removed", function(event:Event):void{
            removeEventListener("rollOver", buttonRollOver);
            removeEventListener("rollOut", buttonRollOut);
            removeEventListener("removed", arguments.callee);
        });
    }
    public function setLabel( label:String ):void{
        _textField.htmlText = <font size={_size} color="#4B4349">{label}</font>.toXMLString();
    }

    protected function buttonRollOver(event:Event):void{
        hover = true;
    }

    protected function buttonRollOut(event:Event):void{
        hover = false;
    }
}