/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1TM7
 */

package 
{
	import flash.display.BlendMode
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import org.papervision3d.core.effects.*;
	import org.papervision3d.core.effects.utils.BitmapDrawCommand;
	import org.papervision3d.materials.BitmapColorMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	[SWF(width=465,height=465,backgroundColor=0x000000)]
	public class Main extends BasicView
	{
		private const SPHERE_NUM:int = 300;
		private var rot:Number = 0;
		
		public function Main():void 
		{
			draw();
			startRendering();
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(event:Event):void 
		{
			rot += 1;
			
			camera.x = 500 * Math.sin(rot * Math.PI / 180);
			camera.z = 500 * Math.cos(rot * Math.PI / 180);
			camera.y = 500 * Math.cos(rot * Math.PI / 180);
			camera.zoom +=(mouseX-camera.zoom)/10;
		}
		
		private function draw():void 
		{
			var _effect:BitmapEffectLayer = new BitmapEffectLayer(viewport, 465, 465);
			_effect.addEffect(new BitmapLayerEffect(new BlurFilter(15, 5, 1)));
		    _effect.addEffect(new BitmapColorEffect(0.8,1,1,1));
			_effect.drawCommand = new BitmapDrawCommand(null, null, BlendMode.SCREEN);
			
			
			viewport.containerSprite.addLayer(_effect);
			
			for (var i:int = 0; i < SPHERE_NUM; i++)
			{
				var material:BitmapColorMaterial = new BitmapColorMaterial(0xFFFFFF, 1);
				var sphere:Sphere=new Sphere(material,1,2,2)
				scene.addChild(sphere);
				sphere.x = Math.random() * 1000-500;
				sphere.y = Math.random() * 1000-500;
				sphere.z = Math.random() * 1000 - 500;
				_effect.addDisplayObject3D(sphere);
			}
		}
		
	}
	
}