/**
 * Copyright l.dijkman ( http://wonderfl.net/user/l.dijkman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1RnC
 */

// forked from hacker_v1lx13we's ブレゼンハム
// http://luberth.com/plotter/content.htm
// bresenham line plotter
package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", framerate="60")]
    public class Bresenham extends Sprite {
            
            private const COL_MAX:Number = 31;
            private const ROW_MAX:Number = 31;
                
            private var canvas:BitmapData;
            private var box:BitmapData;
            private var aBox:BitmapData;
            private var bBox:BitmapData;
                
            private var checkPoints:Array;
            private var passPoints:Array;
                
            private var animation:Boolean;
            private var passCount:Number;
            
        public function Bresenham() {
            
            canvas = new BitmapData(465, 465, false, 0x000000);
            addChild(new Bitmap(canvas));
            
            var rectangle:Rectangle = new Rectangle(1, 1, 14, 14);
            box = new BitmapData(16, 16, false, 0xffffff);
            box.fillRect(rectangle, 0x303030);
            aBox = new BitmapData(16, 16, false, 0xffffff);
            aBox.fillRect(rectangle, 0xff9030);
            bBox = new BitmapData(16, 16, false, 0xffffff);
            bBox.fillRect(rectangle, 0x3090ff);
            
            checkPoints = [];
            passPoints = [];
            
            addEventListener(Event.ENTER_FRAME, handleEnterFrame);
            stage.addEventListener(MouseEvent.CLICK, handleMouseClick);
            
        }
        
        private function handleEnterFrame(ev:Event):void {
                canvas.fillRect(canvas.rect, 0x000000);
                canvas.lock();
                for (var i:uint = 0; i < ROW_MAX; i++) {
                    for (var j:uint = 0; j < COL_MAX; j++) {
                        
                        var p:Point = new Point(j * 15, i * 15);
                        var flg1:Boolean = false;
                        var passFlg:Boolean = false;
                        
                        for (var k:uint = 0; k < checkPoints.length; k++) {
                            if (checkPoints[k].x == j && checkPoints[k].y == i) {
                                flg1 = true;
                                break;
                            }
                        }
                        
                        for (var m:uint = 0; m < Math.min(passPoints.length, passCount); m++) {
                            if (passPoints[m].x == j && passPoints[m].y == i) {
                                passFlg = true;
                                break;
                            }
                        }
                        
                        if (passFlg == true) {
                            canvas.copyPixels(bBox, bBox.rect, p);
                        } else if (flg1 == true) {
                            canvas.copyPixels(aBox, aBox.rect, p);
                        } else {
                            canvas.copyPixels(box, box.rect, p);
                        }
                    }
                }
                canvas.unlock();
                
                if (animation == true) {
                    if (passPoints.length < passCount) {
                        animation = false;
                        checkPoints = [];
                    }
                    passCount++;
                }
        }
            
            private function handleMouseClick(ev:MouseEvent):void {
                if (animation == true) return;
                if (checkPoints.length == 0) {
                    passPoints = [];
                }
                
                checkPoints.push({"x":Math.floor(mouseX / 15), "y":Math.floor(mouseY / 15)});
                
                if (checkPoints.length == 2) {
                    animation = true;
                    calcPassPoints();
                }
            }
            
            private function calcPassPoints():void {
                passPoints = [];
                
                var x1:Number = checkPoints[0].x, y1:Number = checkPoints[0].y;
                var x2:Number = checkPoints[1].x, y2:Number = checkPoints[1].y;
                var a:Number = Math.abs(y2 - y1);
                var b:Number = Math.abs(x2 - x1);
                var dx:int = (x2 >= x1) ? 1 : -1;
                var dy:int = (y2 >= y1) ? 1 : -1;
                var swap:Boolean = (a > b);
                if (swap == true) {
                    a = Math.abs(x2 - x1);
                    b = Math.abs(y2 - y1);
                }
                
                var df1:int = ((b - a) << 1);
                var df2:int = -(a << 1);
                var d:int = b - (a << 1);
                
                passPoints.push({"x":x1, "y":y1});
                
                if (swap == true) {
                    while (y1 != y2) {
                        y1 += dy;
                        if (d < 0) {
                            x1 += dx;
                            d += df1;
                        } else {
                            d += df2;
                        }
                        passPoints.push({"x":x1, "y":y1});
                    }
                } else {
                    while (x1 != x2) {
                        x1 += dx;
                        if (d < 0) {
                            y1 += dy;
                            d += df1;
                        } else {
                            d += df2;
                        }
                        passPoints.push({"x":x1, "y":y1});
                    }
                }
                passCount = 0;                
            }
    }
}