/**
 * Copyright norichika2 ( http://wonderfl.net/user/norichika2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Rmy
 */

package 
{
	import flash.events.Event;
	import flash.system.Security;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.materials.*;

	public class Main4 extends BasicView
	{
		
		//plane作成
		private var plane1:Plane;
		private var plane2:Plane;
		
		//円周
		private var rotaY:Number = 0;
		public function Main4() 
		{
			
			// クロスドメイン対策
			Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
			
			//URL
			const url:String = "http://assets.wonderfl.net/images/related_images/0/03/03b2/03b2dd998e1a6cfc8e5b88a8f4c4b4ec21dfeaba";
			
			//ビットマップマテリアル作成( ゆがみ補正)
			var material:BitmapFileMaterial = new BitmapFileMaterial(url, true);
			
			//マテリアル両面表示
			material.doubleSided = true;
			
			//プレーン作成
			plane1 = new Plane(material, 400, 266, 20);
			scene.addChild(plane1);
			
			startRendering();
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			//マウスの座標位置
			var targetRotY:Number = (mouseY / stage.stageHeight) * 360;
			
			if (targetRotY <= 180) {
				rotaY += 0.05 * (targetRotY - 180);
			} else {
				rotaY -= -0.05 * (targetRotY - 180);
			}
			
			camera.y = -1000 * Math.sin(rotaY * Math.PI / 180);
			camera.z = -1000 * Math.cos(rotaY * Math.PI / 180);
			
		}
		
	}

}