/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1RT1
 */

// forked from sliz's Phys
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author lizhi
     */
    [SWF(width = 465, height = 465, backgroundColor = 0xffffff, frameRate = 100)]
    public class Main extends Sprite 
    {
        private var g:Point = new Point(0,0.01);
        private var b:Number = 0.5;
        private var cf:Number = 0.02;
        private var w:Number;
        private var h:Number;
        
        private var sb:Ball;
        private var max:Number = 40;
        private var numCols:int;
        private var grid:Array;
        public function Main():void 
        {
            w = stage.stageWidth;
            h = stage.stageHeight;
            numCols = Math.ceil(h / max);
            var c:int = 150;
            var b:Ball;
            while(c-->0){
                var ball:Ball = new Ball();
                if (sb) {
                    b.next = ball;
                    b = ball;
                }else {
                    sb = b = ball;
                }
                ball.x = w * Math.random();
                ball.y = h * Math.random();
                ball.r = 1 + 19 * Math.random();
            }
            sb.r = 20;
            addEventListener(Event.ENTER_FRAME, update);
            addChild(new Stats());
        }
        
        private function update(e:Event):void 
        {
            grid = [];
            var b1:Ball = sb;
            sb.x = mouseX;
            sb.y = mouseY;
            while (b1) {
                var x:int = (b1.x + 0.5) / max;
                var y:int = (b1.y + 0.5) / max;
                var v:int = y * numCols + x;
                if (grid[v]==null) {
                    grid[v] = [];
                }
                grid[v].push(b1);
                b1.c = 0;
                b1 = b1.next;
            }
            
            for (var k:int = grid.length - 1; k >= 0;k-- ) {
                var balls:Array = grid[k];
                if (balls) {
                    var arr2:Array = grid[k - 1];
                    if (arr2) {
                        balls = balls.concat(arr2);
                    }
                    arr2 = grid[k - numCols];
                    if (arr2) {
                        balls = balls.concat(arr2);
                    }
                    arr2 = grid[k - numCols - 1];
                    if (arr2) {
                        balls = balls.concat(arr2);
                    }
                    arr2 = grid[k - numCols + 1];
                    if (arr2) {
                        balls = balls.concat(arr2);
                    }
                    for (var i:int = 0; i < balls.length; i++ ) {
                        b1 = balls[i];
                        b1.fy += g.y;
                        if (b1.x - b1.r < 0) b1.fx += b;
                        if (b1.x + b1.r > w) b1.fx -= b;
                        if (b1.y - b1.r < 0) b1.fy += b;
                        if (b1.y + b1.r > h) b1.fy -= b;
                        for (var j:int = i + 1; j < balls.length; j++ ) {
                            var b2:Ball = balls[j];
                            var dx:Number = b1.x - b2.x;
                            var dy:Number = b1.y - b2.y;
                            var d:Number = b1.r + b2.r;
                            if (dx * dx + dy * dy < d * d ) {
                                b1.fx += dx *cf;
                                b1.fy += dy *cf;
                                b2.fx -= dx *cf;
                                b2.fy -= dy * cf;
                                b1.c = 0xff0000;
                                b2.c = 0xff0000;
                            }
                        }
                    }
                }
            }
            
            graphics.clear();
            b1 = sb;
            while (b1) {
                b1.vx += b1.fx;
                b1.vy += (b1.y<h/2)?b1.fy:-b1.fy;
                b1.vx *= 0.95;
                b1.vy *= 0.95;
                b1.x += b1.vx;
                b1.y += b1.vy;
                b1.fx = 0;
                b1.fy = 0;
                graphics.lineStyle(0,b1.c);
                graphics.drawCircle(b1.x, b1.y, b1.r);
                b1 = b1.next;
             }
        }
        
    }
    
}
class Ball {
    public var next:Ball;
    public var c:uint = 0;
    public var x:Number = 0;
    public var y:Number = 0;
    public var r:Number = 10;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var fx:Number = 0;
    public var fy:Number = 0;
}