/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1RR5
 */

package {
  import com.actionscriptbible.Example;
  import flash.events.Event;
  import flash.events.ProgressEvent;
  import flash.net.Socket;
  import flash.system.Security;
  public class ch28ex3 extends Example {
    protected var sock:Socket;
    public function ch28ex3():void {
      Security.loadPolicyFile("http://actionscriptbible.com/crossdomain.xml");
      sock = new Socket("actionscriptbible.com", 80); //http uses port 80
      sock.addEventListener(Event.CONNECT, onConnected);
      sock.addEventListener(Event.CLOSE, onClosed);
      sock.addEventListener(ProgressEvent.SOCKET_DATA, onSocketData);
    }
    protected function onConnected(event:Event):void {
      //make a request
      var request:String = "GET /files/hand.xml HTTP/1.1\n" +
                           "Host: actionscriptbible.com\n\n";
      sock.writeUTFBytes(request);
    }
    protected function onSocketData(event:ProgressEvent):void {
      //we got some data... let's just let it fill up the buffer
      //and wait for the server to disconnect!
      trace(event);
      
    }
    protected function onClosed(event:Event):void {
      var response:String = sock.readUTFBytes(sock.bytesAvailable);
      trace(response);
    }
  }
}