/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Qon
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.text.TextField;
    public class FlashTest extends Sprite {
		private const MAP:Array = new Array(
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
			0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
			0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0 
		);
		private const WIDTH:uint = 34;
		private const HEIGHT:uint = 20;
		
        public function FlashTest() {
			var g:Graphics = this.graphics;
			
			for (var x:uint = 0; x < WIDTH; ++x) {
				for (var y:uint = 0; y < HEIGHT; ++y) {
					var data:uint = MAP[(y * WIDTH) + x];
					if (data != 0) {
						if (x > 0) {
							var isLeft:Boolean = MAP[(y * WIDTH) + (x - 1)] == 0;
							if (isLeft) {
								var left:WallLeft = new WallLeft();
								left.x = x * Parts.SIZE;
								left.y = y * Parts.SIZE;
								this.addChild(left);
							}
						}

						if (x < WIDTH - 1) {
							var isRight:Boolean = MAP[(y * WIDTH) + (x + 1)] == 0;
							if (isRight) {
								var right:WallRight = new WallRight();
								right.x = (x + 1) * Parts.SIZE;
								right.y = y * Parts.SIZE;
								this.addChild(right);
							}
						}
						
						var parts:Parts = new Parts();
						parts.x = x * Parts.SIZE;
						parts.y = y * Parts.SIZE;
						this.addChild(parts); 

						if (y > 0) {
							var isTop:Boolean = MAP[((y - 1) * WIDTH) + x] == 0;
							if (isTop) {
								var floor:Floor = new Floor();
								floor.x = x * Parts.SIZE;
								floor.y = y * Parts.SIZE + (Parts.SIZE * 0.5);
								this.addChild(floor);
							}
						}
					}
					
				}
			}
        }
    }
}
import flash.display.Sprite;

class Parts extends Sprite {
	static public const SIZE:uint = 12;
	
	public function Parts() {
		this.graphics.beginFill(0x808080);
		this.graphics.drawRect(0, 0, SIZE, SIZE);
		this.graphics.endFill();
	}
}

class Floor extends Sprite {
	public function Floor() {
		this.graphics.beginFill(0xd0d0d0);
		this.graphics.drawRect(0, -Parts.SIZE, Parts.SIZE, Parts.SIZE * 0.5);
		this.graphics.endFill();
		
		this.rotationX = 40;
	}
}

class WallLeft extends Sprite {
	public function WallLeft() {
		this.graphics.beginFill(0x404040);
		this.graphics.drawRect(-Parts.SIZE, 0, Parts.SIZE, Parts.SIZE);
		this.graphics.endFill();
		
		this.rotationY = -90;
	}	
}

class WallRight extends Sprite {
	public function WallRight() {
		this.graphics.beginFill(0xa8a8a8);
		this.graphics.drawRect(0, 0, Parts.SIZE, Parts.SIZE);
		this.graphics.endFill();
		
		this.rotationY = 90;
	}	
}
