/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1PnO
 */

// forked from ton's Movie 15 Puzzle : Warp
// forked from bkzen's MoviePuzzleTest
/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mJwf
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    
    /**
     * [企画]皆で動くパズル作ろうぜ
     * http://wonderfl.net/c/yb0z
     * 前から気になってた事があって、Wonderfl は色んな作品があるけど作品同士のつながりがないのが気になっていた。
     * 例えば、パーツだけ作って読み込んでロードするだけで使える[素材]を作るとか。
     * あと Fork することで何かに参加できるようにすればもっと面白い事になって行きそうなきがする。
     * チェックメイトやJAMのような方法ではなく、Forkされたもの全てが一つの作品を作るというか。
     * これからもチェックメイトやJAM以外にも[企画]タグや[素材]タグが増えていくといいなぁ。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "60", width = "465", height = "465")]
    public class MoviePuzzle extends Sprite 
    {
        private static const BG_COLOR: uint = 0x000000;
        private static const FRAME_RATE: uint = 30;
        
        public function MoviePuzzle() 
        {
            // ローダーで読み込まれなかった時の為のデモ用
            addEventListener(Event.ADDED_TO_STAGE, demo);
        }
        
        /**
         * 
         * MoviePuzzle -> MovieJigsawPuzzle
         *         obj["disp"]      : DisplayObject : 描画対象このオブジェクトの440x440の範囲で切り取られて描画されます。
         *         obj["color"]     : uint : 背景色(省略時は0x000000)
         *         obj["frameRate"] : uint : フレームレート(省略時は60)
         *         obj["level"]     : uint : 上限レベル(省略時は1)
         * @param    obj : <Object>
         */
        public function initialize(obj: Object): void
        {    
            disp = new Warp();
            obj["disp"]  = disp;
            obj["color"] = BG_COLOR;
            obj["frameRate"]  = FRAME_RATE;
            obj["level"] = 3;
        }
        
        /**
         * スタートする時に呼ばれます。
         * @param    level : uint : 指定レベル : 変える必要があれば。
         */
        public function start(level: uint): void
        {
            Object(disp).start(level);
        }
        
        /**
         * 終了した時に呼ばれます。
         */
        public function end(): void
        {
            Object(disp).end();
        }
        
        private var disp: DisplayObject;
        
        /**
         * デモ用
         * @param    e
         */
        private function demo(e: Event): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, demo);
            //
            var obj: Object = {};
            initialize(obj);
            disp = obj["disp"];
            var col: uint = obj["color"];
            var bmd: BitmapData = new BitmapData(440, 440, false, col);
            var bmp: Bitmap = new Bitmap(bmd, "auto", true);
            start(1);
            addChild(bmp);
            addEventListener(Event.ENTER_FRAME, function(e: Event): void {
                bmd.lock();
                bmd.fillRect(bmd.rect, col);
                bmd.draw(disp);
                bmd.unlock();
            } );
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.PerspectiveProjection;
import flash.geom.Point;


class Warp extends Sprite {
    private const W:int = 465;
    private const H:int = 465;
    private const R:int = 5000;
    private const PI:Number = Math.PI;
        
    private var perspective:PerspectiveProjection;
    private var level:uint;

    public function Warp() {
        this.transform.perspectiveProjection = new PerspectiveProjection();
        perspective = this.transform.perspectiveProjection;
        perspective.fieldOfView = 175;

    }
        
    private function onEnterFrameHandler(e:Event):void {
        var p:Point;
        
        switch(level){
            case 1: p = new Point(W/2, H/2); break;
            case 2: p = new Point(mouseX, mouseY); break;
            case 3: p = new Point(W-mouseX, H-mouseY); break;
        }

        perspective.projectionCenter = p;
        
        var n:int = Rect3D.moveZ / 6;
        for (var i:int = 0; i < n; i++){
            var rect:Rect3D = new Rect3D(0xffffff, 500);
        
            var rad:Number = Math.random() * 2 * PI;
            rect.x = R * Math.cos(rad);
            rect.y = R * Math.sin(rad);
            rect.z = Math.random() * 100 + 3000;
            rect.rotationX = 180-Math.atan2(rect.y - H / 2, rect.x - W / 2) * 180 / PI;
            rect.rotationY = 90;
            addChild(rect);
        }
    }
    

    public function start(level: uint): void {
        this.level = level;
        addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);        
    }
    
    public function end():void {
        removeEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
    }
}


import flash.display.Sprite;
import flash.events.Event;
class Rect3D extends Sprite {
    public static var moveZ:int = 30;
    
    public function Rect3D(color:uint, size:int) {
        graphics.beginFill(color);
        graphics.drawRect( -size / 2, -size / 2, size, size);
        graphics.endFill();
        addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
    }
    
    private function onEnterFrameHandler(e:Event):void {
        this.z -= moveZ;
        if (this.z <= 0) {
            parent.removeChild(this);
            removeEventListener(e.type, arguments.callee);
        }
    }
}

