/**
 * Copyright lol_lol ( http://wonderfl.net/user/lol_lol )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1PZm
 */

// forked from lol_lol's 多角形作成
package {
	import flash.text.TextFormat;
	import flash.accessibility.Accessibility;
	import flash.text.TextField;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.utils.*;
	import flash.geom.Point;
	
	[SWF(framerate = 10)]
    public class Ring extends Sprite {
    		private static const PADDING:uint = 100;
    		private static const SIZE:uint = 50;
    		
    		private var _center:Point;
    		private var _r:uint;
    		private var _speed:int = 1;
    		
    		private var _ring:Sprite;
    		private var on_guruguru:Boolean = false;
    		
        public function Ring() {
        		createRing();
        }
        
        public function createRing():void
        {
        		//キャンバスの中心にパディングしてリングを描くよ！
        		var _w:uint = stage.stageWidth;
        		var _h:uint = stage.stageHeight;
        		
        		_r = (_h - PADDING) / 2;
        		_center = new Point((SIZE + _w) / 2, (SIZE + _h) / 2);
        		
        		var _radian:Number;
        		var _p:Point;
        		
        		//リングごと回転させるためのコンテナさん
        		_ring = new Sprite();
        		_ring.x = _w / 2;
        		_ring.y = _h / 2;
        		
        		//リングのアイテムさん
        		var _ringItems:Sprite = new Sprite();
        		_ringItems.x = -1 * (_r + SIZE);
        		_ringItems.y = -1 * (_r + SIZE);
        		
        		//_ring.width = _r;
        		//_ring.height = _r * 2;
        		
        		for(var i:uint = 0; i < 360; i += 10)
        		{
        			_radian = i * Math.PI / 180;
        			_p = new Point(_center.x + Math.cos(_radian) * _r, _center.y + Math.sin(_radian) * _r);
        			var _po:Polygon = createPolygon(SIZE, _p.x, _p.y);
        			
        			_ringItems.addChild(_po);
        		}
        		
        		_ring.addChild(_ringItems);
        		addChild(_ring);
        		
        		//ぐるぐるする
        		addEventListener(Event.ENTER_FRAME, update);
        		
        		stage.addEventListener(MouseEvent.MOUSE_OVER, function(e:Event):void{
        			//2秒間回す
        			if( !on_guruguru ){
        				on_guruguru = true;
        				_speed *= 10;
	        			
	        			setTimeout(function():void{
	        				on_guruguru = false;
	        				_speed /= 10;
	        			}, 2000);
        			}
        		});
        }
        
        //毎秒1０ぐるぐる
        public function update(e:Event):void
        {
        		_ring.rotation += _speed;
        }
        
        public function createPolygon(_size:uint, xnum:uint, ynum:uint):Polygon
        {
        		var _vertex:uint, _is_star:Boolean, _alpha:Number;
        		_vertex = 3 + Math.ceil(Math.random() * 30);
        		_is_star = (Math.random() >= 0.5);
        		
        		_alpha = 0.5 + Math.random() * 0.5;
        		var _po:Polygon = new Polygon(_vertex, {
        			size: _size,
        			is_star: _is_star,
        			alpha: _alpha
        		});
        		_po.x = xnum;
        		_po.y = ynum;
        		
        		return _po;
        }
    }
}


/*
	正多角形を生成するスクリプトです。
	ご自由にお使いください。
	
	下のクラスをコピペでおｋ
	
	Usage:
		var po:Polygon = new Polygon(頂点数:uint, options:Object{
			サイズ size:uint,
			色 color:uint,
			星型にするか is_star:Boolean,
			アルファ値 alpha:Number
		});
		var po:Polygon = new Polygon(5); //五角形をランダムなサイズと色で表示
		var po:Polygon = new Polygon(5, 100);	 //五角形をランダムな色で表示
		var po:Polygon = new Polygon(5, 100, 0xFF0000, true); //普通の星を表示
	
	サイズ指定がなければ、DEFAULT_SIZEで設定されたサイズを使用します。
	IS_RANDOM_SIZE = true にすると、
	サイズ指定がないときに、DEFAULT_SIZEを元にランダムでサイズを決定します。
	
	色指定がない場合、全色域からランダムで色が選ばれます。
	
	星型で色とサイズをランダムにしたい場合、
	size = 0
	color = 0x1000000 をセットしてください。
	
	Author: lol_lol
	Date: 2010/02/15
	Licence: MIT
*/
import flash.display.Shape;
import flash.geom.Point;

class Polygon extends Shape
{
	public static const DEFAULT_SIZE:uint = 100;
	public static const IS_RANDOM_SIZE:Boolean = true;
	
	public function Polygon(vertex:uint, options:Object)
	{
		if( vertex <= 2 ) return;
		
		//サイズ指定なければデフォルトを使用
		if( !options.size ){
			if( IS_RANDOM_SIZE ){
				options.size = Math.round(DEFAULT_SIZE / 2 + Math.random() * DEFAULT_SIZE / 2);
			}else{
				options.size = DEFAULT_SIZE;
			}
		}
		//半径
		var _r:uint = options.size / 2;
		
		var color:uint;
		//カラー指定なければ適当
		if( !options.color || options.color > 0x1000000 ){
			color = Math.random() * 0x1000000;
		}else{
			color = options.color;
		}
		
		//ちょこっと回転させて自然にする
		var _rotate:Number= (vertex%2 == 0) ? (180 / vertex) : (90 / vertex);
		
		//Set points
		var _points:Array = new Array();
		var _radian:Number;
		for(var i:Number = 0; i < vertex; i++){
			_radian = (360 / vertex * i - _rotate) * Math.PI / 180;
			_points.push(new Point(Math.cos(_radian) * _r, Math.sin(_radian) * _r));
			
			if( options.is_star ){
				_radian = (360 / vertex * (i + 0.5) - _rotate) * Math.PI / 180;
				_points.push(new Point(Math.cos(_radian) * _r / 2, Math.sin(_radian) * _r / 2));
			}
		}
		
		//create Shape
		this.alpha = options.alpha ? options.alpha : 1;
		graphics.beginFill(color);
		_points.forEach(function(e:Point, index:uint, p:Array):void{
			if( index == 0 ){
				graphics.moveTo(e.x - _r, e.y - _r);
			}else{
				graphics.lineTo(e.x - _r, e.y - _r);
			}
		});
		graphics.endFill();
	}
}