/**
 * Copyright yun ( http://wonderfl.net/user/yun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1OR8
 */

// forked from yun's 動画情報取得とコントロール
// forked from yun's 動画の再生
package
{
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.NetStatusEvent;
    import flash.geom.Matrix;
    import flash.media.Video;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.utils.getTimer;
    import flash.system.Security;
    
    public class Main extends Sprite
    {
        private var _connection:NetConnection;
        private var _stream:NetStream;
        private var _video:Video = new Video;
        private var _canvas:BitmapData;
        private var _matrixArray:Array = [];
        private const SPLIT_NUM:int = 8;
        private var _videoURL:String = "http://www.muraken.biz/wonderfl/construction.mp4";
        
        public function Main():void
        {
            Security.loadPolicyFile( "http://www.muraken.biz/crossdomain.xml" );            
            _connection = new NetConnection();
            _connection.addEventListener( NetStatusEvent.NET_STATUS, _netStatusHandler );
            _connection.connect( null );
        }
        
        private function _netStatusHandler( e:NetStatusEvent ):void
        {
            if( e.info.code=="NetConnection.Connect.Success" )_connectStream();
            else if( e.info.code=="NetStream.Play.Stop" )_stream.seek( 0 );
        }
        
        private function _connectStream():void
        {
            _stream = new NetStream( _connection );
            _stream.addEventListener( NetStatusEvent.NET_STATUS, _netStatusHandler );
            _stream.client = this;
            _stream.bufferTime = 3;
            _video.attachNetStream( _stream );
            
            _stream.play( _videoURL );
            addEventListener( Event.ENTER_FRAME, _onEnterFrame );
        }
        
        private function _onEnterFrame( e:Event ):void
        {
            if ( !_canvas ) return;
            _canvas.fillRect( _canvas.rect, 0x00000000 );
            _canvas.draw( _video );
            var _mtx:Matrix = _matrixArray[ Math.floor( ( getTimer() / 1000 ) % SPLIT_NUM ) ];
            _mtx.ty-=1;
            _mtx.ty%=stage.stageHeight;
            graphics.clear();
            graphics.beginBitmapFill( _canvas, _mtx, true, true );
            graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
            graphics.endFill();
        }
        
        // callback
        public function onMetaData( info:Object ):void
        {
            if ( !_canvas )
            {
                _canvas = new BitmapData( info.width, info.height, true, 0x00000000 );
                var _scale:Number;
                for ( var i:int = 0; i < SPLIT_NUM; i++ )
                {
                    _scale = stage.stageWidth / ( _canvas.width * ( i + 1 ) );
                    _matrixArray.push( new Matrix( _scale, 0, 0, _scale ) );
                }
            }
        }
        public function onCuePoint( info:Object ):void {}
        public function onXMPData( info:Object ):void {}
    } 
}