/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1OQv
 */

package {
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	[SWF(width = "240",height = "180")]
	public class LeapYearTest extends Sprite {
		private const AMOUNT:uint = 2000000;
		private var myVector:Vector.<uint>  = new Vector.<uint>(AMOUNT);
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		private var my_fmt:TextFormat = new TextFormat();
		public function LeapYearTest() {
			// Creating a TextField for display
			createTextField();
			createArray();
			warmingUp();
			// Starting Test
			test(simple_if, "simple");
			test(refined_if, "refined order");
			test(refined_if2, "refined order (implicit)");
			test(compositeConditions, "composite conditions");
			test(conditionalOperator, "conditional operator");
			/*
			*/
		}
		private function warmingUp():void {
			var _vector:Vector.<uint> = myVector;
			var nAmount:uint = _vector.length;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var nYear:uint = _vector[i]
			}
		}
		private function test(myFunction:Function, label_str:String):void {
			var _vector:Vector.<uint> = myVector;
			var nAmount:uint = _vector.length;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var nYear:uint = _vector[i]
				var bResult:Boolean = myFunction(nYear);
			}
			xTrace(label_str, getTimer() - started);
		}
		private function simple_if(nYear:int):Boolean {
			if (nYear % 400 == 0) {
				return true;
			} else if (nYear % 100 == 0) {
				return false;
			} else if (nYear % 4 == 0) {
				return true;
			} else {
				return false;
			}
		}
		private function refined_if(nYear:int):Boolean {
			if (nYear % 4 != 0) {
				return false;
			} else if (nYear % 100 != 0) {
				return true;
			} else if (nYear % 400 != 0) {
				return false;
			} else {
				return true;
			}
		}
		private function refined_if2(nYear:int):Boolean {
			if (nYear % 4) {
				return false;
			} else if (nYear % 100) {
				return true;
			} else if (nYear % 400) {
				return false;
			} else {
				return true;
			}
		}
		private function compositeConditions(nYear:int):Boolean {
			if (nYear % 4 == 0 && nYear % 100 != 0 || nYear % 400 == 0) {
				return true;
			} else {
				return false;
			}
		}
		private function conditionalOperator(nYear:int):Boolean {
			return (nYear % 4)   ? false :
				   (nYear % 100) ? true :
				   (nYear % 400) ? false :
				    true;
		}
		private function createArray():void {
			var nAmount:uint = AMOUNT;
			for (var i:uint = 0; i < nAmount; i++) {
				myVector[i] = i;
			}
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_fmt.align = TextFormatAlign.RIGHT;
			my_txt.x +=  50;
			my_txt.defaultTextFormat = my_fmt;
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
		}
		private function xTrace(_str:String, n:int):void {
			my_txt.appendText(String(n) + "\n");
			label_txt.appendText(_str + ":" + "\n");
		}
	}
}