/**
 * Copyright kkstudio2007 ( http://wonderfl.net/user/kkstudio2007 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1OOj
 */

// forked from iong's txt rain
/* 
 * txtの雨（仮組み）ver.upでいろいろ加える
 * イメージはcaligariのPV背景、2:58ぐらい（http://www.youtube.com/watch?v=Y1bWW4GeiHE）
 * 文章は青空文庫「雨夜詞」の一節（http://www.aozora.gr.jp/cards/000154/card47992.html）
 *
 * win以外の動作環境がないので、fontが出てなかったらすいません。。
 */
package{

    import flash.display.Sprite;

    public class FlashTest extends Sprite
    {
        import flash.text.TextField;
        import flash.display.Shape;
        import flash.display.Bitmap;
        import flash.display.BitmapData;
        import flash.display.BlendMode;
        import flash.geom.Matrix;
        import flash.geom.Point;
        import flash.filters.BlurFilter;

        import flash.events.Event;

        import flash.system.Capabilities;

//        import flash.display.StageQuality;
//        import flash.display.StageAlign;
//        import flash.display.StageScaleMode;

        private var cv:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
        private var cvb:Bitmap;
        private var _SPR:Sprite = new Sprite();
        private var _SPB:Sprite = new Sprite();
        private const _TXTR:String = "雨夜偷牛的人,把我从人类"
            + "身体中偷走.我仍在沉睡 "
            + "我被带到身体之外 "
            + "雨夜偷牛的人";
        private var aryTxt:Array = new Array();

        private var tfFont:String;

        // 文字サイズ：メイン（avg）
        private const _tfSize:uint   = 128;
        // 文字サイズ：背景（avg）
        private const _tfSizeBG:uint = 32;
        // 文字サイズランダム増減
        private const _tfSizeOV:uint = 8;

        // 文字を作る間隔
        private const _iMC:uint   = 30;
        private var iMakeCnt:uint = 10;

        // 単語の大まかな抽出用
        private const _SPTxt:Array= new Array(
             "Junghian"
            ,"alter-ego"
            ,"Merleau Pont"
            ,"on a rainy night a cow thief"
            ,"steals me"
            ,"from my human body"
            ,"I am still deeply sleeping"
            ,"I am taken beyond my body"
            ,"climbs in my window"
            ,"a rainy night a cow thief"
        );

        private var flBlurBg:BlurFilter = new BlurFilter(4,4);

        public function FlashTest():void
        {
//            stage.quality   = StageQuality.LOW;
//            stage.scaleMode = StageScaleMode.NO_SCALE;
//            stage.align     = StageAlign.TOP_LEFT;
            addChild(cvb=new Bitmap(cv));
            cvb.smoothing  = true;

            _SPB.filters = [flBlurBg];

            addChild(_SPB);
            addChild(_SPR);

            init();

            addEventListener(Event.ENTER_FRAME, act);
        }

        private function init():void
        {
            // OSフォント指定
            switch(Capabilities.os.substr(0,3).toLowerCase()){
                case "win":
                    tfFont = "MS Mincho";
                    break;
                case "mac":
                    tfFont = "Hiragino Mincho Pro";
                    break;
                default:
                    tfFont = "Kochi Mincho";
            }

            // 単語配列作成
            var sp:RegExp = new RegExp(_SPTxt.join("|"));
            aryTxt = _TXTR.split(sp);
        }

        private function act(e:Event):void
        {
            if(iMakeCnt<=0){
                var txt:Sprite   = new MakeTxt(retTxt(), tfFont, _tfSize, _tfSizeOV);
                var txtBg:Sprite = new MakeTxt(retTxt(), tfFont, _tfSizeBG, _tfSizeOV);
                initPiece(txt);
                initPiece(txtBg);
                _SPB.addChild(txtBg);
                _SPR.addChild(txt);
                iMakeCnt = _iMC;

            }else iMakeCnt--;

//            drawAll();
        }

        private function drawAll():void
        {
            cv.lock();
            cv.draw(_SPB);
            cv.draw(_SPR);
            cv.unlock();
            cv.applyFilter(cv, cv.rect, new Point(), new BlurFilter(16,16));
        }

        private function initPiece(txt:Sprite):void
        {
            txt.x  = -100 + Math.round(Math.random()*(stage.stageWidth+100));
            txt.y -= txt.height - Math.round(Math.random()*20);
        }

        // 単語をランダムで返す
        private function retTxt():String
        {
            var retVal:String = "";
            var str:String = "";
            while(str==""){
                var ret:* = aryTxt[(Math.round(Math.random()*aryTxt.length))];
                if(ret!=null)str = ret;
            }
            for(var i:int=0; i<str.length; i++){
                retVal += (retVal!="") ? "\n": "";
                retVal += str.substr(i,1);
            }
            return retVal;
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.events.Event;
class MakeTxt extends Sprite
{
    // 初期rotationの幅（+-intR）
    public var intR:uint = 12;
    // 回転／frm の大きさ（+-intRAdd）/100する
    public var intRAdd:Number = 5;

    public function MakeTxt(txt:String, tfFont:String, ts:uint, tsp:uint):void
    {
        var tfmt:TextFormat = new TextFormat();
        tfmt.font = tfFont;
        tfmt.size = ts-tsp+Math.round(Math.random()*(tsp*2));
        tfmt.color= 0xffffff;
        var tf:TextField = new TextField();
        tf.autoSize= TextFieldAutoSize.LEFT;
        tf.text = txt;
        tf.selectable = false;
        tf.setTextFormat(tfmt);

        var bmd:BitmapData = new BitmapData(tf.width, tf.height, true, 0x0);
        bmd.draw(tf);

        var retVal:Bitmap = new Bitmap(bmd);
//        retVal.smoothing  = true;

        init();

        addChild(retVal);
        addEventListener(Event.ENTER_FRAME, act);
    }

    private function init():void
    {
        rotation = -(intR)+Math.round(Math.random()*(intR*2));
        intRAdd  = ( -(intRAdd)+Math.round(Math.random()*(intRAdd*2)) )/100;
    }

    private function act(e:Event):void
    {
        y += 8 + (alpha*10);
        rotation += intRAdd;
        alpha -=0.02;
        if(alpha<=0){
            removeEventListener(Event.ENTER_FRAME, act);
            e.target.parent.removeChild(this);
        }
    }
}