/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Ns8
 */

// forked from kotobuki's Union Ping Test
// A very simple ping test regarding Union
// 
// Reference:
// http://www.unionplatform.com/?page_id=44

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;

    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;

    public class UnionSender extends Sprite {
        private var reactor:Reactor;

        private var testRoom:Room;

        private var incomingMessages:TextField;

        public function UnionSender() {
            buildUI();

            reactor = new Reactor();
            reactor.addEventListener(ReactorEvent.READY, readyListener);
            reactor.connect("tryunion.com", 9100);
        }

        private function readyListener(e:ReactorEvent):void {
            incomingMessages.appendText("Connected to Union\n");
            testRoom = reactor.getRoomManager().createRoom("funnelTestRoom");
            testRoom.addMessageListener("TEST_MESSAGE", testMessageListener);
            testRoom.join();

            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, mousePressed);
            this.stage.addEventListener(MouseEvent.MOUSE_UP, mouseReleased);
        }

        private function mousePressed(e:MouseEvent):void {
            testRoom.sendMessage("TEST_MESSAGE", true, null, "On");
        }

        private function mouseReleased(e:MouseEvent):void {
            testRoom.sendMessage("TEST_MESSAGE", true, null, "Off");
        }

        private function buildUI():void {
            incomingMessages = new TextField;
            incomingMessages.border = true;
            incomingMessages.background = true;
            incomingMessages.width = 400;
            incomingMessages.height = 200;

            addChild(incomingMessages);
        }

        private function testMessageListener(fromClient:IClient, messageText:String):void {
            incomingMessages.appendText("message: " + fromClient.getClientID() + "=>" + messageText + "\n");
        }
    }
}