/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Nmq
 */

package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.events.Event;
	import frocessing.color.ColorHSV;
	import org.libspark.betweenas3.BetweenAS3;
 
	public class Main extends Sprite
	{
		private var color:ColorHSV;
 
		public function Main()
		{
			color = new ColorHSV();
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			color.h++;
 
			var bitmap:Bitmap = Text.textToBitmap(Text.createTextField("A", 80, color.value));
			bitmap.x = mouseX - bitmap.width / 2;
			bitmap.y = mouseY - bitmap.height / 2;
			addChild(bitmap);
 
			BetweenAS3.serial
			(
				BetweenAS3.tween(bitmap, { _blurFilter:{blurX:30, blurY:30}, alpha:0.0 }, null, 1.0),
				BetweenAS3.removeFromParent(bitmap)
			).play();
		}
	}
}
 
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.text.TextField;
import flash.text.TextFormat;
 
class Text
{
	public static function createTextField(text:String, size:int, color:int):TextField
	{
		var tf:TextField = new TextField();
		tf.defaultTextFormat = new TextFormat("_typeWriter", size, color, true);
		tf.text = text;
		tf.autoSize = "left";
 
		return tf;
	}
 
	public static function textToBitmap(tf:TextField, transparent:Boolean = true):Bitmap
	{
		var bd:BitmapData = new BitmapData(tf.width, tf.height, transparent, 0x0);
		bd.draw(tf);
 
		return new Bitmap(bd);
	}
}
