/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1NY7
 */

// forked from enecre's 陣取りゲーム
package {
    import flash.utils.ByteArray;
    import flash.net.FileReference;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.Point;
    import flash.text.TextField;
    import com.bit101.components.*;
    public class Main extends Sprite {
        
        private var model:JintoriModel;
        private var view:JintoriView;
        private var tf:TextField;
        private var button:PushButton;
        
        public function Main() {
            //Settings
            var N:int = Configurations.N;
            model = new JintoriModel(N);
            view = new JintoriView(N, 300);
            view.x = stage.stageWidth / 2 - view.width / 2;
            view.y = stage.stageWidth / 2 - view.height / 2;
            addChild(view);
            
            tf = new TextField();
            tf.autoSize = "left";
            tf.text = "You: 0  Com: 0";
            tf.x = stage.stageWidth / 2 - tf.width / 2;
            tf.y = view.y + view.height + 10;
            addChild(tf);
            
            button = new PushButton(this, 0, 0, "Load", onLoadButtonClicked);
            button.x = view.x + view.width - button.width;
            button.y = view.y - button.height - 15;
        }
        
        private function init(event:Event = null):void {
            model.init();
            view.init();
            tf.text = "You: 0  Com: 0";
        }
        
        private function playMyHand(event:JintoriEvent = null):void {
            if (model.exists(event.x, event.y, event.z)) return;
            var ps:Array = model.put(event.x, event.y, event.z, JintoriModel.WHITE);
            view.addLine(event.x, event.y, event.z);
            if (ps[0] != null) view.addRect(ps[0].x, ps[0].y, JintoriModel.WHITE);
            if (ps[1] != null) view.addRect(ps[1].x, ps[1].y, JintoriModel.WHITE);
            if (updateInformation()) {
                onGameEnd();
                return;
            }
        }
        
        private function playComHand(p:Point3D):void {
            if (model.exists(p.x, p.y, p.z)) return;
            var ps:Array = model.put(p.x, p.y, p.z, JintoriModel.BLACK);
            view.addLine(p.x, p.y, p.z);
            if (ps[0] != null) view.addRect(ps[0].x, ps[0].y, JintoriModel.BLACK);
            if (ps[1] != null) view.addRect(ps[1].x, ps[1].y, JintoriModel.BLACK);
            if (updateInformation()) {
                onGameEnd();
                return;
            }
        }
        
        private function onGameEnd():void {
            var countW:int = model.count(JintoriModel.WHITE);
            var countB:int = model.count(JintoriModel.BLACK);
        }
        
        private function updateInformation():Boolean {
            var countW:int = model.count(JintoriModel.WHITE);
            var countB:int = model.count(JintoriModel.BLACK);
            tf.text = "You: " + countW + "  Com: " + countB;
            var N:int = Configurations.N;
            if (countW + countB == N * N) return true;
            return false;
        }
        
        
        private var fr:FileReference;
        private function onLoadButtonClicked(event:MouseEvent):void{
            fr = new FileReference();
            fr.addEventListener(Event.SELECT, onSelect);
            fr.browse();
        }
        
        private function onSelect(event:Event):void{
            fr.removeEventListener(Event.SELECT, onSelect);
            fr.addEventListener(Event.COMPLETE, onLoadComplete);
            fr.load();
        }

        private function onLoadComplete(event:Event):void{
            fr.removeEventListener(Event.COMPLETE, onLoadComplete);
            var data:ByteArray = fr.data;
            trace(data.bytesAvailable);
            trace(data.length);
            try {trace(data.readUTFBytes(3000));} catch(e:Error){trace("doya");}
        }
    }
}
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.text.*;

var trace:Function = Wonderfl.log;

class Configurations {
    public static const sensitivity:int = 15;
    public static const dot_color:int = 0x0000ff;
    public static const line_color:int = 0xdddd33;
    public static const suggest_line_color:int = 0x88dddd;
    public static const N:int = 4;
}

class JintoriEvent extends Event{
    private var _x:int;
    private var _y:int;
    private var _z:int;
    
    public function get x():int{ return _x; }
    public function get y():int{ return _y; }
    public function get z():int { return _z; }
    
    public function JintoriEvent(type:String, x:int, y:int, z:int){
        super(type);
        this._x = x;
        this._y = y;
        this._z = z;
    }
}


class JintoriView extends Sprite{
    private var _size:int;
    private var _wh:int;
    
    public function JintoriView(size:int, wh:int){
        this._size = size;
        this._wh = wh;
        init();
    }
    
    public function init():void{
        var g:Graphics = this.graphics;
        g.clear();
        g.beginFill(Configurations.dot_color);
        for(var i:int = 0; i < _size + 1; i++){
            for(var j:int = 0; j < _size + 1; j++){
                g.drawCircle(i * _wh / _size, j * _wh / _size, 5);
            }      
        }
        g.endFill();
    }

    public function addLine(x:int, y:int, z:int):void{
        var g:Graphics = graphics;
        var interval:int = _wh / _size;
        g.lineStyle(5, Configurations.line_color);
        g.moveTo(x * interval, y * interval);
        if (z == 0) g.lineTo((x + 1) * interval, y * interval);
        else g.lineTo(x * interval, (y + 1) * interval);
    }
    
    public function addRect(x:int, y:int, who:int):void
    {
        var g:Graphics = graphics;
        var interval:int = _wh / _size;
        g.beginFill(who);
        g.drawRect(x * interval, y * interval, interval, interval);
        g.endFill();
    }

}

class JintoriModel{
    public static const NUTRAL:int = 0;
    public static const BLACK :int = 0xff0000;
    public static const WHITE :int = 0x00ff00;
    
    private var l:Array/*Boolean[size+1][size+1][2]*/; 
    private var t:Array/*int[size][size]*/;
    private var _size:int;
    
    public function JintoriModel(size:int){
        if(size > 10)throw new Error("size too big.");
        this._size = size;
        init();
    }
    
    public function init():void{
        this.l = [];
        for(var i:int = 0; i < _size + 1; i++){
            l[i] = [];
            for(var j:int = 0; j < _size + 1; j++){
                if(i == _size && j == _size)l[i][j] == [null, null];
                else if (i == _size) l[i][j] = [null, false];
                else if (j == _size) l[i][j] = [false, null];
                else l[i][j] = [false,false];
            }
        }
        this.t = [];
        for(i = 0; i < _size; i++){
            t[i] = [];
            for(j = 0; j < _size; j++){
                t[i][j] = NUTRAL;
            }
        }
    }
    
    public function put(x:int, y:int, z:int, who:int):Array{
        lines[x][y][z] = true;
        var res:Array = [null, null];
        if(z == 0){
            if (y != 0 && l[x][y - 1][0] && l[x][y - 1][1] && l[x + 1][y - 1][1]){
                t[x][y - 1] = who;
                res[0] = new Point(x, y - 1);
            }
            if (y != size && l[x][y][1] && l[x][y + 1][0] && l[x + 1][y][1]){
                t[x][y] = who;
                res[1] = new Point(x, y);
            }
        }
        else{
            if (x != 0 && l[x - 1][y][0] && l[x - 1][y][1] && l[x - 1][y + 1][0]){
                t[x - 1][y] = who;
                res[0] = new Point(x - 1, y);
            }
            if (x != size && l[x][y][0] && l[x][y + 1][0] && l[x + 1][y][1]){
                t[x][y] = who;
                res[1] = new Point(x, y);
            }
        }
        return res;
    }
    
    public function exists(x:int, y:int, z:int):Boolean {
        return l[x][y][z];
    }
    
    public function count(who:int):int {
        var res:int = 0;
        for (var i:int = 0; i < _size; i++) {
            for (var j:int = 0; j < _size; j++) {
                if (t[i][j] == who) res++;
            }
        }
        return res;
    }
    
    public function get lines():Array{ return l; }
    public function get rects():Array{ return t; }
    public function get size ():int  { return _size;  }
}

class Point3D {
    private var _x:int;
    private var _y:int;
    private var _z:int;
    
    public function get x():int { return _x; }
    public function get y():int { return _y; }
    public function get z():int { return _z; }
    
    public function Point3D(x:int, y:int, z:int) {
        this._x = x;
        this._y = y;
        this._z = z;
    }
}