/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1NSy
 */

// SocialIMEを規格外の使い方で使って読みを取得する。
// 直接はアクセスできないので、5ivestarのproxyをお借りしました。
package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;
    public class FlashTest extends Sprite {
        private var _yg : YomiGetter;
        private var _tf : TextField;
        private var _s : int;
        
        public function FlashTest() {
            _yg = new YomiGetter();
            _yg.addEventListener(Event.COMPLETE, onGetComplete);
            _s = getTimer();
            _yg.get("墨西哥で卍解");
        }
        
        private function onGetComplete(e : Event) : void
        {
            _yg.removeEventListener(Event.COMPLETE, onGetComplete);
            var tf : TextField = new TextField();
            addChild(tf);
            tf.width = 465;
            tf.height = 465;
            tf.text = "" + _yg.yomi + "\n" + (getTimer() - _s) + "ms";
        }
        
        private static function setParams(o : Object, params : Object) : void
        {
            for (var key : String in params) {
                o[key] = params[key];
            }
        }
    }
}

import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.system.Security;

class YomiGetter extends EventDispatcher
{
    private var _ul : URLLoader;
    private var _yomi : String;
    private var _str : String;
    
    public function YomiGetter()
    {
        Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
    }
    
    public function get(str : String) : void
    {
        _str = str;
        
        _ul = new URLLoader();
        _ul.addEventListener(Event.COMPLETE, onLoadComplete);
        _ul.load(new URLRequest(
            "http://5ivestar.org/proxy/" + 
            "http://www.social-ime.com/api/?string=" + encodeURIComponent(str) + "&charset=UTF-8"
        ));
    }
    
    private function onLoadComplete(e : Event) : void
    {
        _ul.removeEventListener(Event.COMPLETE, onLoadComplete);
        var res : String = _ul.data;
        _yomi = null;
        if(res != null){
            var yomi : String = "";
            for each(var line : String in res.split("\n")){
                var words : Array = line.split("\t");
                var f : Boolean = false;
                for each(var word : String in words){
                    if(word.match(/^[あ-ゞ]+$/)){
                        yomi += word;
                        f = true;
                        break;
                    }
                }
                if(!f && words.length > 0){
                    yomi += words[0];
                }
            }
            _yomi = yomi;
        }
        dispatchEvent(new Event(Event.COMPLETE));
    }
    
    public function get yomi() : String { return _yomi; }
    public function get str() : String { return _str; }
}